/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

public class SpawnEggColors {
    private final int primaryColor;
    private final int secondaryColor;

    private SpawnEggColors(int primary, int secondary) {
        this.primaryColor = primary;
        this.secondaryColor = secondary;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public static SpawnEggColors getColorsForDimension(Dimension dimension) {
        switch (dimension) {
            case OVERWORLD: {
                return new SpawnEggColors(5240, 30740);
            }
            case NETHER: {
                return new SpawnEggColors(12126720, 0x540000);
            }
            case END: {
                return new SpawnEggColors(15267765, 986904);
            }
            case ICEIKA: {
                return new SpawnEggColors(0xE6E6E6, 3602682);
            }
            case EDEN: {
                return new SpawnEggColors(14661905, 8873984);
            }
            case WILDWOOD: {
                return new SpawnEggColors(675282, 729423);
            }
            case APALACHIA: {
                return new SpawnEggColors(8404128, 3284040);
            }
            case SKYTHERN: {
                return new SpawnEggColors(0xD0D0D0, 0x3C3C3C);
            }
            case MORTUM: {
                return new SpawnEggColors(0x1E1E1E, 657930);
            }
            case ARCANA: {
                return new SpawnEggColors(1975950, 9936364);
            }
            case VETHEA: {
                return new SpawnEggColors(18012, 1504400);
            }
            case BOSS: {
                return new SpawnEggColors(65532, 0);
            }
        }
        return new SpawnEggColors(0xFAFAFA, 328965);
    }

    public static enum Dimension {
        OVERWORLD,
        NETHER,
        END,
        ICEIKA,
        EDEN,
        WILDWOOD,
        APALACHIA,
        SKYTHERN,
        MORTUM,
        ARCANA,
        VETHEA,
        BOSS;

    }
}

