/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import divinerpg.registries.BlockRegistry;
import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;

public class Utils {
    private static Set<UUID> DEV_LIST = new ConcurrentSet();
    private static Set<UUID> TESTER_LIST = new ConcurrentSet();
    private static Set<UUID> SPECIAL_LIST = new ConcurrentSet();
    private static Set<UUID> ARTIST_LIST = new ConcurrentSet();
    private static Set<UUID> FRIEND_LIST = new ConcurrentSet();

    public static boolean isDeveloperName(UUID name) {
        return DEV_LIST.contains(name);
    }

    public static boolean isTesterName(UUID name) {
        return TESTER_LIST.contains(name);
    }

    public static boolean isSpecial(UUID name) {
        return SPECIAL_LIST.contains(name);
    }

    public static boolean isArtist(UUID name) {
        return ARTIST_LIST.contains(name);
    }

    public static boolean isFriend(UUID name) {
        return FRIEND_LIST.contains(name);
    }

    public static void loadHatInformation() {
        CompletableFuture.supplyAsync(() -> {
            String urlString = "https://raw.githubusercontent.com/DivineRPG/DivineRPG-Assets/main/hats.json";
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(urlString).openConnection();
                con.setConnectTimeout(1000);
                InputStream in2 = con.getInputStream();
                List lines = IOUtils.readLines((InputStream)in2, (Charset)Charset.defaultCharset());
                return String.join((CharSequence)"\n", lines);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }).thenApply(rawJson -> {
            DEV_LIST.clear();
            TESTER_LIST.clear();
            SPECIAL_LIST.clear();
            ARTIST_LIST.clear();
            FRIEND_LIST.clear();
            if (rawJson != null) {
                try {
                    HatsInfo info = (HatsInfo)new Gson().fromJson(rawJson, HatsInfo.class);
                    if (info != null) {
                        DEV_LIST.addAll(info.dev);
                        TESTER_LIST.addAll(info.tester);
                        SPECIAL_LIST.addAll(info.special);
                        ARTIST_LIST.addAll(info.artists);
                        FRIEND_LIST.addAll(info.friend);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rawJson;
        });
    }

    public static CompletableFuture<UUID> getLicenceId(String nick) {
        return CompletableFuture.supplyAsync(() -> {
            String url = "https://api.mojang.com/users/profiles/minecraft/" + nick;
            UUID result = new UUID(0L, 0L);
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                connection.setRequestMethod("GET");
                InputStream stream = connection.getInputStream();
                String json = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                JsonObject object = (JsonObject)new Gson().fromJson(json, JsonObject.class);
                if (!object.has("error")) {
                    result = UUIDTypeAdapter.fromString((String)object.get("id").getAsString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        });
    }

    public static boolean bordersTar(IBlockReader world, int x, int y, int z) {
        for (int i = x - 4; i <= x + 4; ++i) {
            for (int j = y; j <= y + 1; ++j) {
                for (int k = z - 4; k <= z + 4; ++k) {
                    if (world.func_180495_p(new BlockPos(i, j, k)).func_177230_c() != BlockRegistry.smolderingTar) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void spawnPersistentEntity(World world, BlockPos pos, LivingEntity entity) {
        entity.revive();
        entity.func_174828_a(pos, 0.0f, 0.0f);
        world.func_217376_c((Entity)entity);
    }

    public static void populateLootChestBelow(World world, BlockPos pos, Random rand, ResourceLocation lootTable) {
        BlockPos chestPosition = pos.func_177977_b();
        TileEntity tileEntity = world.func_175625_s(chestPosition);
        if (tileEntity instanceof LockableLootTileEntity) {
            ((LockableLootTileEntity)tileEntity).func_189404_a(lootTable, rand.nextLong());
        }
    }

    public class HatsInfo {
        public List<UUID> dev;
        public List<UUID> tester;
        public List<UUID> special;
        public List<UUID> artists;
        public List<UUID> friend;
    }
}

