/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import divinerpg.blocks.base.BlockModCrop;
import divinerpg.blocks.base.BlockModGrass;
import divinerpg.blocks.base.BlockModSlab;
import divinerpg.blocks.twilight.BlockTwilightGrass;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EntityEquipmentPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class GenerateBlockLoot
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public GenerateBlockLoot(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block block : ForgeRegistries.BLOCKS) {
            Function<Block, LootTable.Builder> func;
            if (!"divinerpg".equals(block.getRegistryName().func_110624_b())) continue;
            if (block.getRegistryName().func_110623_a().contains("_glass")) {
                func = this.functionTable.getOrDefault(block, GenerateBlockLoot::genSilk);
                tables.put(block.getRegistryName(), func.apply(block));
                continue;
            }
            if (block.getRegistryName().func_110623_a().contains("_vine") || block instanceof BlockTwilightGrass) {
                func = this.functionTable.getOrDefault(block, GenerateBlockLoot::genSilkShears);
                tables.put(block.getRegistryName(), func.apply(block));
                continue;
            }
            if (block == BlockRegistry.edenOre || block == BlockRegistry.wildwoodOre || block == BlockRegistry.apalachiaOre || block == BlockRegistry.skythernOre || block == BlockRegistry.mortumOre) {
                func = this.functionTable.getOrDefault(block, GenerateBlockLoot::genTwilightOre);
                tables.put(block.getRegistryName(), func.apply(block));
                continue;
            }
            if (block instanceof BlockModSlab) {
                func = this.functionTable.getOrDefault(block, GenerateBlockLoot::genSlab);
                tables.put(block.getRegistryName(), func.apply(block));
                continue;
            }
            if (block.getRegistryName().func_110623_a().contains("_leaves") || block instanceof BlockModCrop || block instanceof BlockModGrass || block.getRegistryName().toString().contains("_wall")) continue;
            func = this.functionTable.getOrDefault(block, GenerateBlockLoot::genRegular);
            tables.put(block.getRegistryName(), func.apply(block));
        }
        for (Map.Entry e : tables.entrySet()) {
            Path path = GenerateBlockLoot.getPath(this.generator.func_200391_b(), (ResourceLocation)e.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)e.getValue()).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)path);
        }
    }

    public String func_200397_b() {
        return "DivineRPG block loot tables";
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder genRegular(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genSilk(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))));
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genSilkShears(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212840_b_((ILootCondition.IBuilder)MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ)).func_216297_a(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))))));
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genTwilightOre(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217985_a(EntityEquipmentPredicate.Builder.func_234266_a_().func_234267_a_(ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)ItemRegistry.edenHelmet).func_200310_b()).func_234269_b_(ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)ItemRegistry.edenChestplate).func_200310_b()).func_234270_c_(ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)ItemRegistry.edenLeggings).func_200310_b()).func_234271_d_(ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)ItemRegistry.edenBoots).func_200310_b()).func_234268_b_())))).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genSlab(Block b) {
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)b).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder genFortune(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t));
        return LootTable.func_216119_b().func_216040_a(pool);
    }
}

