/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util.teleport;

import divinerpg.DivineRPG;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.KeyRegistry;
import divinerpg.world.arcana.ArcanaMazeGenerator;
import divinerpg.world.arcana.ArcanaRooms;
import divinerpg.world.arcana.ArcanaStructureHandler;
import divinerpg.world.arcana.Cell;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class ArcanaTeleporter
implements ITeleporter {
    public static final int PORTAL_SEARCH_CHUNK_RADIUS = 4;
    protected ServerWorld world;
    protected Random random = new Random();

    public ArcanaTeleporter(ServerWorld var1) {
        this.world = var1;
    }

    public void placeInPortal(Entity entity, float rotationYaw) {
        if (this.world.func_234923_W_().equals(KeyRegistry.ARCANA_WORLD)) {
            int chunkX = (MathHelper.func_76128_c((double)entity.func_226277_ct_()) & 0xFFFFFFF0) / 16;
            int chunkZ = (MathHelper.func_76128_c((double)entity.func_226281_cx_()) & 0xFFFFFFF0) / 16;
            if (!this.placeInExistingPortal(entity, rotationYaw)) {
                this.makePortalRoom(chunkX, chunkZ);
                this.placeInExistingPortal(entity, rotationYaw);
            }
        } else {
            int chunkZ;
            int chunkX = (MathHelper.func_76128_c((double)entity.func_226277_ct_()) - 8 & 0xFFFFFFF0) / 16;
            BlockPos pos = this.locateOverworldPortal((World)this.world, chunkX, chunkZ = (MathHelper.func_76128_c((double)entity.func_226281_cx_()) - 8 & 0xFFFFFFF0) / 16);
            if (pos == null) {
                ServerPlayerEntity player;
                BlockPos spawnPoint = null;
                if (entity instanceof ServerPlayerEntity) {
                    player = (ServerPlayerEntity)entity;
                    spawnPoint = player.func_241140_K_();
                }
                if (spawnPoint == null) {
                    player = (ServerPlayerEntity)entity;
                    spawnPoint = player.func_241140_K_();
                }
                entity.func_70634_a((double)spawnPoint.func_177958_n(), (double)this.getTopBlock((World)this.world, pos), (double)spawnPoint.func_177952_p());
            } else {
                entity.func_70634_a((double)(pos.func_177958_n() + this.random.nextInt(3)), (double)(this.getTopBlock((World)this.world, pos) + 1), (double)(pos.func_177952_p() + this.random.nextInt(3)));
            }
        }
    }

    protected int getTopBlock(World world, BlockPos pos) {
        int y = -1;
        int k = 0;
        boolean topBlock = false;
        for (int j = 255; j >= 63; --j) {
            if (!world.func_180495_p(pos.func_177982_a(0, j, 0)).func_177230_c().equals(Blocks.field_150350_a)) {
                topBlock = true;
                ++k;
            }
            if (!topBlock || k != 1) continue;
            y = j;
        }
        return y;
    }

    private BlockPos locateOverworldPortal(World world, int chunkX, int chunkZ) {
        BlockPos pos = null;
        for (int radius = 0; radius <= 4 && (pos = this.locatePortalByRadius(world, chunkX, chunkZ, radius)) == null; ++radius) {
        }
        return pos;
    }

    @Nullable
    private BlockPos locatePortalByRadius(World world, int chunkX, int chunkZ, int radius) {
        BlockPos result;
        for (int currentChunkX = chunkX - radius; currentChunkX <= chunkX + radius; ++currentChunkX) {
            result = this.locatePortalInChunk(world, currentChunkX, chunkZ - radius);
            if (result != null) {
                return result;
            }
            result = this.locatePortalInChunk(world, currentChunkX, chunkZ + radius);
            if (result == null) continue;
            return result;
        }
        for (int currentChunkZ = chunkZ - radius + 1; currentChunkZ <= chunkZ + radius - 1; ++currentChunkZ) {
            result = this.locatePortalInChunk(world, chunkX - radius, currentChunkZ);
            if (result != null) {
                return result;
            }
            result = this.locatePortalInChunk(world, chunkX + radius, currentChunkZ);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private BlockPos locatePortalInChunk(World world, int chunkX, int chunkZ) {
        BlockPos.Mutable searchPos = new BlockPos.Mutable();
        int baseX = chunkX * 16;
        int baseZ = chunkZ * 16;
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    searchPos.func_181079_c(baseX + x, y, baseZ + z);
                    if (world.func_180495_p((BlockPos)searchPos).func_177230_c() != BlockRegistry.arcanaPortal) continue;
                    return searchPos;
                }
            }
        }
        return null;
    }

    public boolean placeInExistingPortal(Entity entity, float rotationYaw) {
        if (this.world.func_234923_W_().equals(KeyRegistry.ARCANA_WORLD)) {
            int chunkX = entity.field_70170_p.func_217349_x((BlockPos)entity.func_233580_cy_()).func_76632_l().field_77276_a;
            int portalLocationX = chunkX * 16 + 6 + 8;
            int portalLocationY = 9;
            int chunkZ = entity.field_70170_p.func_217349_x((BlockPos)entity.func_233580_cy_()).func_76632_l().field_77275_b;
            int portalLocationZ = chunkZ * 16 + 5 + 8;
            if (this.world.func_180495_p(new BlockPos(portalLocationX, portalLocationY, portalLocationZ)).func_177230_c() == BlockRegistry.arcanaHardPortalFrame) {
                entity.func_70012_b((double)portalLocationX + 1.5, (double)portalLocationY, (double)portalLocationZ + 2.5, rotationYaw, 0.0f);
                entity.field_70166_s = 0.0;
                entity.field_70167_r = 0.0;
                entity.field_70169_q = 0.0;
                return true;
            }
            BlockPos.Mutable searchPos = new BlockPos.Mutable();
            for (int searchX = portalLocationX - 64; searchX < portalLocationX + 64; searchX += 16) {
                for (int searchZ = portalLocationZ - 64; searchZ < portalLocationZ + 64; searchZ += 16) {
                    searchPos.func_181079_c(searchX, portalLocationY, searchZ);
                    if (this.world.func_180495_p((BlockPos)searchPos).func_177230_c() != BlockRegistry.arcanaHardPortalFrame) continue;
                    entity.func_70012_b((double)searchX + 1.5, (double)portalLocationY, (double)searchZ + 2.5, rotationYaw, 0.0f);
                    entity.field_70166_s = 0.0;
                    entity.field_70167_r = 0.0;
                    entity.field_70169_q = 0.0;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void makePortalRoom(int chunkX, int chunkZ) {
        Cell cell = ArcanaMazeGenerator.obtainMazePiece(chunkX, chunkZ, this.world.func_72905_C());
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_226691_t_(pos.func_177982_a(16, 0, 16));
        long worldSeed = this.world.func_72905_C();
        ArcanaStructureHandler portalRoom = ArcanaRooms.getPortalRoomByType(cell.getPieceType());
        Template template = this.world.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", portalRoom.getName()));
        this.world.func_201674_k().setSeed(this.world.func_72905_C());
        long k = this.world.func_201674_k().nextLong() / 2L * 2L + 1L;
        long l = this.world.func_201674_k().nextLong() / 2L * 2L + 1L;
        this.world.func_201674_k().setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        if (this.world.func_180495_p(new BlockPos(x + 8, 8, z + 8)).func_177230_c() == Blocks.field_150350_a) {
            Rotation rotation = cell.getPieceType() == Cell.PieceType.CROSSROADS ? Rotation.values()[this.world.func_201674_k().nextInt(4)] : cell.getRotation();
            BlockPos adjustedPosition = this.adjustForRotation(pos, template.func_186259_a(), rotation);
            if (template != null && portalRoom.getName() != null) {
                template.func_237152_b_((IServerWorld)this.world, adjustedPosition, new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_186220_a(rotation).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a), this.world.func_201674_k());
            }
        }
    }

    private BlockPos adjustForRotation(BlockPos position, BlockPos size, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return position;
            }
            case CLOCKWISE_90: {
                return position.func_177982_a(size.func_177952_p() - 1, 0, 0);
            }
            case CLOCKWISE_180: {
                return position.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return position.func_177982_a(0, 0, size.func_177958_n() - 1);
            }
        }
        DivineRPG.LOGGER.warn("Invalid structure rotation passed in somehow, please report this.");
        return position;
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (entity instanceof ServerPlayerEntity) {
            this.placeInPortal(entity, yaw);
        } else {
            this.placeInExistingPortal(entity, yaw);
        }
        entity.func_242279_ag();
        entity = repositionEntity.apply(false);
        if (destWorld != entity.field_70170_p.func_73046_m().func_71218_a(World.field_234918_g_)) {
            entity.func_70634_a(entity.func_226277_ct_(), 2.0, entity.func_226281_cx_());
        } else {
            entity.func_70634_a(entity.func_226277_ct_(), (double)this.getTopBlock((World)this.world, new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())), entity.func_226281_cx_());
        }
        return entity;
    }
}

