/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util.teleport;

import divinerpg.blocks.base.BlockModPortal;
import divinerpg.util.PortalShape;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;

public class DivineTeleporter
implements ITeleporter {
    public static DivineTeleporter INSTANCE = null;
    protected static Block portal;
    protected static Block frame;
    private static PointOfInterestType point;
    protected final ServerWorld world;
    private final boolean hasFrame;

    public DivineTeleporter(ServerWorld worldIn, Block portal, Block frame, boolean hasFrame, PointOfInterestType point) {
        DivineTeleporter.portal = portal;
        DivineTeleporter.frame = frame;
        INSTANCE = this;
        this.world = worldIn;
        this.hasFrame = hasFrame;
        DivineTeleporter.point = point;
    }

    public Optional<TeleportationRepositioner.Result> getExistingPortal(BlockPos pos) {
        PointOfInterestManager poiManager = this.world.func_217443_B();
        poiManager.func_226347_a_((IWorldReader)this.world, pos, 64);
        Optional<PointOfInterest> optional = poiManager.func_226353_b_(poiType -> poiType.equals(point), pos, 64, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingDouble(poi -> poi.func_218261_f().func_177951_i((Vector3i)pos)).thenComparingInt(poi -> poi.func_218261_f().func_177956_o())).filter(poi -> this.world.func_180495_p(poi.func_218261_f()).func_235901_b_((Property)BlockStateProperties.field_208199_z)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.func_218261_f();
            this.world.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.world.func_180495_p(blockpos);
            return TeleportationRepositioner.func_243676_a((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.world.func_180495_p(posIn) == blockstate);
        });
    }

    public Optional<TeleportationRepositioner.Result> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.world.func_175723_af();
        int dimensionLogicalHeight = this.world.func_234938_ad_() - 1;
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        for (BlockPos.Mutable blockpos$mutable1 : BlockPos.func_243514_a((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(dimensionLogicalHeight, this.world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockpos$mutable1.func_177958_n(), blockpos$mutable1.func_177952_p()));
            if (!worldborder.func_177746_a((BlockPos)blockpos$mutable1) || !worldborder.func_177746_a((BlockPos)blockpos$mutable1.func_189534_c(direction, 1))) continue;
            blockpos$mutable1.func_189534_c(direction.func_176734_d(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.func_185336_p(l);
                if (!this.world.func_175623_d((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && this.world.func_175623_d((BlockPos)blockpos$mutable1.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > dimensionLogicalHeight || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.func_185336_p(l);
                if (!this.checkRegionForPlacement((BlockPos)blockpos$mutable1, mutablePos, direction, 0)) continue;
                double d2 = pos.func_177951_i((Vector3i)blockpos$mutable1);
                if (this.checkRegionForPlacement((BlockPos)blockpos$mutable1, mutablePos, direction, -1) && this.checkRegionForPlacement((BlockPos)blockpos$mutable1, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.func_185334_h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.func_185334_h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(this.world.func_234938_ad_() - 10)), pos.func_177952_p()).func_185334_h();
            Direction direction1 = direction.func_176746_e();
            if (!worldborder.func_177746_a(blockpos)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? frame.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                        mutablePos.func_239621_a_((Vector3i)blockpos, k2 * direction.func_82601_c() + l1 * direction1.func_82601_c(), i3, k2 * direction.func_82599_e() + l1 * direction1.func_82599_e());
                        if (mutablePos.func_177956_o() > 100) {
                            mutablePos.func_189534_c(Direction.DOWN, 20);
                        }
                        this.world.func_175656_a((BlockPos)mutablePos, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                mutablePos.func_239621_a_((Vector3i)blockpos, k1 * direction.func_82601_c(), i2, k1 * direction.func_82599_e());
                if (mutablePos.func_177956_o() > 100) {
                    mutablePos.func_189534_c(Direction.DOWN, 20);
                }
                this.world.func_180501_a((BlockPos)mutablePos, frame.func_176223_P(), 3);
            }
        }
        BlockState portal = (BlockState)DivineTeleporter.portal.func_176223_P().func_206870_a(BlockModPortal.AXIS, (Comparable)axis);
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.func_239621_a_((Vector3i)blockpos, j2 * direction.func_82601_c(), l2, j2 * direction.func_82599_e());
                if (mutablePos.func_177956_o() > 100) {
                    mutablePos.func_189534_c(Direction.DOWN, 20);
                }
                this.world.func_180501_a((BlockPos)mutablePos, portal, 18);
            }
        }
        return Optional.of(new TeleportationRepositioner.Result(blockpos.func_185334_h(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.Mutable offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.func_176746_e();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.func_239621_a_((Vector3i)originalPos, directionIn.func_82601_c() * i + direction.func_82601_c() * offsetScale, j, directionIn.func_82599_e() * i + direction.func_82599_e() * offsetScale);
                if (j < 0 && !this.world.func_180495_p((BlockPos)offsetPos).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (j < 0 || this.world.func_175623_d((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        boolean isntOverworld;
        boolean bl = isntOverworld = destWorld.func_234923_W_() == this.world.func_234923_W_();
        if (entity.field_70170_p.func_234923_W_() != this.world.func_234923_W_() && !isntOverworld) {
            return null;
        }
        if (!this.hasFrame) {
            return new PortalInfo(new Vector3d(entity.func_226277_ct_(), 255.0, entity.func_226281_cx_()), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        }
        WorldBorder border = destWorld.func_175723_af();
        double minX = Math.max(-2.9999872E7, border.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, border.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.func_177733_e() - 16.0);
        double coordinateDifference = DimensionType.func_242715_a((DimensionType)entity.field_70170_p.func_230315_m_(), (DimensionType)destWorld.func_230315_m_());
        BlockPos blockpos = new BlockPos(MathHelper.func_151237_a((double)(entity.func_226277_ct_() * coordinateDifference), (double)minX, (double)maxX), entity.func_226278_cu_(), MathHelper.func_151237_a((double)(entity.func_226281_cx_() * coordinateDifference), (double)minZ, (double)maxZ));
        return this.getOrMakePortal(entity, blockpos).map(result -> {
            Vector3d vector3d;
            Direction.Axis axis;
            BlockState blockstate = entity.field_70170_p.func_180495_p(entity.func_233580_cy_());
            if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
                axis = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
                TeleportationRepositioner.Result rectangle = TeleportationRepositioner.func_243676_a((BlockPos)entity.func_233580_cy_(), (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.field_70170_p.func_180495_p(pos) == blockstate);
                vector3d = entity.func_241839_a(axis, rectangle);
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vector3d(0.5, 0.0, 0.0);
            }
            return PortalShape.createPortalInfo(destWorld, result, axis, vector3d, entity.func_213305_a(entity.func_213283_Z()), entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
        }).orElse(null);
    }

    protected Optional<TeleportationRepositioner.Result> getOrMakePortal(Entity entity, BlockPos pos) {
        Optional<TeleportationRepositioner.Result> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        Direction.Axis portalAxis = this.world.func_180495_p(entity.func_233580_cy_()).func_235903_d_(BlockModPortal.AXIS).orElse(Direction.Axis.X);
        Optional<TeleportationRepositioner.Result> makePortal = this.makePortal(pos, portalAxis);
        if (!makePortal.isPresent()) {
            // empty if block
        }
        return makePortal;
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity.func_242279_ag();
        return super.placeEntity(entity, currentWorld, destWorld, yaw, repositionEntity);
    }
}

