/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util.teleport;

import divinerpg.blocks.base.BlockModPortal;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.KeyRegistry;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class VetheaTeleporter
implements ITeleporter {
    public static final int PORTAL_SEARCH_CHUNK_RADIUS = 4;
    protected ServerWorld world;
    protected Random random = new Random();

    public VetheaTeleporter(ServerWorld var1) {
        this.world = var1;
    }

    public void placeInPortal(Entity entity, float rotationYaw) {
        if (this.world.func_234923_W_().equals(KeyRegistry.VETHEA_WORLD)) {
            int chunkX = (MathHelper.func_76128_c((double)entity.func_226277_ct_()) & 0xFFFFFFF0) / 16;
            int chunkZ = (MathHelper.func_76128_c((double)entity.func_226281_cx_()) & 0xFFFFFFF0) / 16;
            if (!this.placeInExistingPortal(entity, rotationYaw)) {
                this.makePortalAt((World)this.world, entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177956_o(), entity.func_233580_cy_().func_177952_p());
                this.placeInExistingPortal(entity, rotationYaw);
            }
        } else {
            ServerPlayerEntity player;
            int chunkZ;
            int chunkX = (MathHelper.func_76128_c((double)entity.func_226277_ct_()) - 8 & 0xFFFFFFF0) / 16;
            BlockPos pos = this.locateOverworldPortal((World)this.world, chunkX, chunkZ = (MathHelper.func_76128_c((double)entity.func_226281_cx_()) - 8 & 0xFFFFFFF0) / 16);
            if (pos == null && entity instanceof ServerPlayerEntity && (player = (ServerPlayerEntity)entity).func_241140_K_() != null) {
                BlockPos blockPos = player.func_241140_K_();
            }
        }
    }

    protected int getTopBlock(World world, BlockPos pos) {
        int y = -1;
        int k = 0;
        boolean topBlock = false;
        for (int j = 255; j >= 63; --j) {
            if (!world.func_180495_p(pos.func_177982_a(0, j, 0)).func_177230_c().equals(Blocks.field_150350_a)) {
                topBlock = true;
                ++k;
            }
            if (!topBlock || k != 1) continue;
            y = j;
        }
        return y;
    }

    private BlockPos locateOverworldPortal(World world, int chunkX, int chunkZ) {
        BlockPos pos = null;
        for (int radius = 0; radius <= 4 && (pos = this.locatePortalByRadius(world, chunkX, chunkZ, radius)) == null; ++radius) {
        }
        return pos;
    }

    @Nullable
    private BlockPos locatePortalByRadius(World world, int chunkX, int chunkZ, int radius) {
        BlockPos result;
        for (int currentChunkX = chunkX - radius; currentChunkX <= chunkX + radius; ++currentChunkX) {
            result = this.locatePortalInChunk(world, currentChunkX, chunkZ - radius);
            if (result != null) {
                return result;
            }
            result = this.locatePortalInChunk(world, currentChunkX, chunkZ + radius);
            if (result == null) continue;
            return result;
        }
        for (int currentChunkZ = chunkZ - radius + 1; currentChunkZ <= chunkZ + radius - 1; ++currentChunkZ) {
            result = this.locatePortalInChunk(world, chunkX - radius, currentChunkZ);
            if (result != null) {
                return result;
            }
            result = this.locatePortalInChunk(world, chunkX + radius, currentChunkZ);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private BlockPos locatePortalInChunk(World world, int chunkX, int chunkZ) {
        BlockPos.Mutable searchPos = new BlockPos.Mutable();
        int baseX = chunkX * 16;
        int baseZ = chunkZ * 16;
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    searchPos.func_181079_c(baseX + x, y, baseZ + z);
                    if (world.func_180495_p((BlockPos)searchPos).func_177230_c().func_176223_P() == BlockRegistry.vetheaPortal.func_176223_P()) {
                        return searchPos;
                    }
                    if (world.func_180495_p((BlockPos)searchPos).func_177230_c().func_176223_P() != BlockRegistry.nightmareBed.func_176223_P()) continue;
                    return searchPos;
                }
            }
        }
        return null;
    }

    public boolean placeInExistingPortal(Entity entity, float rotationYaw) {
        double var24;
        int searchRange = 200;
        double var10 = -1.0;
        int var12 = 0;
        int var13 = 0;
        int var14 = 0;
        int entityPosX_floored = MathHelper.func_76128_c((double)entity.field_70169_q);
        int entityPosY = MathHelper.func_76128_c((double)entity.field_70166_s);
        for (int searchX = entityPosX_floored - searchRange; searchX <= entityPosX_floored + searchRange; ++searchX) {
            double var18 = (double)searchX + 0.5 - entity.field_70169_q;
            for (int searchZ = entityPosY - searchRange; searchZ <= entityPosY + searchRange; ++searchZ) {
                double var21 = (double)searchZ + 0.5 - entity.field_70166_s;
                for (int searchY = 63; searchY >= 0; --searchY) {
                    if (!this.isBlockPortal((World)this.world, searchX, searchY, searchZ)) continue;
                    while (this.isBlockPortal((World)this.world, searchX, searchY - 1, searchZ)) {
                        --searchY;
                    }
                    var24 = (double)searchY + 0.5 - entity.field_70167_r;
                    double var26 = var18 * var18 + var24 * var24 + var21 * var21;
                    if (!(var10 < 0.0) && !(var26 < var10)) continue;
                    var10 = var26;
                    var12 = searchX;
                    var13 = searchY;
                    var14 = searchZ;
                }
            }
        }
        if (var10 >= 0.0) {
            double var28 = (double)var12 + 0.5;
            double var22 = (double)var13 + 0.5;
            var24 = (double)var14 + 0.5;
            if (this.isBlockPortal((World)this.world, var12 - 1, var13, var14)) {
                var28 -= 0.5;
            }
            if (this.isBlockPortal((World)this.world, var12 + 1, var13, var14)) {
                var28 += 0.5;
            }
            if (this.isBlockPortal((World)this.world, var12, var13, var14 - 1)) {
                var24 -= 0.5;
            }
            if (this.isBlockPortal((World)this.world, var12, var13, var14 + 1)) {
                var24 += 0.5;
            }
            entity.func_70012_b(var28, var22 + 1.0, var24 + 1.0, rotationYaw, 0.0f);
            entity.func_213293_j(0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    public boolean isBlockPortal(World var1, int var2, int var3, int var4) {
        return var1.func_180495_p(new BlockPos(var2, var3, var4)).func_177230_c().func_176223_P() == BlockRegistry.vetheaPortal.func_176223_P();
    }

    private void makePortalAt(World world, int x, int y, int z) {
        y = 16;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 6; ++k) {
                    world.func_180501_a(new BlockPos(x + i - 3, y + j + 1, z + k - 4), Blocks.field_150350_a.func_176223_P(), 0);
                }
            }
        }
        world.func_180501_a(new BlockPos(x + 1, y, z), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x, y, z), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 2, y, z), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 1, z - 1), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 1, z + 1), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 2, z - 2), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 2, z + 2), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 3, z + 1), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 3, z - 1), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 4, z), BlockRegistry.mortumBlock.func_176223_P(), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 1, z), (BlockState)BlockRegistry.vetheaPortal.func_176223_P().func_206870_a(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 2, z + 1), (BlockState)BlockRegistry.vetheaPortal.func_176223_P().func_206870_a(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 2, z), (BlockState)BlockRegistry.vetheaPortal.func_176223_P().func_206870_a(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 2, z - 1), (BlockState)BlockRegistry.vetheaPortal.func_176223_P().func_206870_a(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
        world.func_180501_a(new BlockPos(x + 1, y + 3, z), (BlockState)BlockRegistry.vetheaPortal.func_176223_P().func_206870_a(BlockModPortal.AXIS, (Comparable)Direction.Axis.Z), 0);
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (entity instanceof ServerPlayerEntity) {
            this.placeInPortal(entity, yaw);
        } else {
            this.placeInExistingPortal(entity, yaw);
        }
        entity.func_242279_ag();
        entity = repositionEntity.apply(false);
        if (destWorld != entity.field_70170_p.func_73046_m().func_71218_a(World.field_234918_g_)) {
            entity.func_70634_a(entity.func_226277_ct_(), 17.0, entity.func_226281_cx_());
        } else if (this.locateOverworldPortal((World)this.world, entity.field_70176_ah, entity.field_70164_aj) == null) {
            entity.func_70634_a(entity.func_226277_ct_(), (double)this.getTopBlock((World)this.world, new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())), entity.func_226281_cx_());
        } else {
            entity.func_70634_a((double)this.locateOverworldPortal((World)this.world, entity.field_70176_ah, entity.field_70164_aj).func_177958_n(), (double)this.locateOverworldPortal((World)this.world, entity.field_70176_ah, entity.field_70164_aj).func_177956_o(), (double)this.locateOverworldPortal((World)this.world, entity.field_70176_ah, entity.field_70164_aj).func_177952_p());
        }
        return entity;
    }
}

