/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.arcana;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.DivineRPG;
import divinerpg.world.DivineChunkGenerator;
import divinerpg.world.arcana.ArcanaMazeGenerator;
import divinerpg.world.arcana.ArcanaRooms;
import divinerpg.world.arcana.ArcanaStructureHandler;
import divinerpg.world.arcana.Cell;
import divinerpg.world.arcana.DivineStructureBlockProcessor;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class ArcanaChunkGenerator
extends DivineChunkGenerator {
    public static final Codec<ArcanaChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.field_222542_c), (App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(ChunkGenerator::func_235957_b_)).apply((Applicative)instance, instance.stable(ArcanaChunkGenerator::new)));

    public ArcanaChunkGenerator(BiomeProvider provider, DimensionStructuresSettings settings) {
        super(provider, settings);
    }

    @Override
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public void func_230351_a_(WorldGenRegion region, StructureManager structureManager) {
        int x = region.func_201679_a() * 16;
        int z = region.func_201680_b() * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        long worldSeed = region.func_72905_C();
        Cell cell = ArcanaMazeGenerator.obtainMazePiece(region.func_201679_a(), region.func_201680_b(), worldSeed);
        ArcanaStructureHandler toGenerate = ArcanaRooms.getRandomStructureByType(region.func_201674_k(), cell.getPieceType());
        Template template = region.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", toGenerate.getName()));
        region.func_201674_k().setSeed(region.func_72905_C());
        long k = region.func_201674_k().nextLong() / 2L * 2L + 1L;
        long l = region.func_201674_k().nextLong() / 2L * 2L + 1L;
        region.func_201674_k().setSeed((long)region.func_201679_a() * k + (long)region.func_201680_b() * l ^ region.func_72905_C());
        if (region.func_180495_p(new BlockPos(x + 8, 8, z + 8)).func_177230_c() == Blocks.field_150350_a) {
            Rotation rotation = cell.getPieceType() == Cell.PieceType.CROSSROADS ? Rotation.values()[region.func_201674_k().nextInt(4)] : cell.getRotation();
            BlockPos adjustedPosition = this.adjustForRotation(pos, template.func_186259_a(), rotation);
            if (template != null && toGenerate.getName() != null) {
                template.func_237152_b_((IServerWorld)region, adjustedPosition, new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_186220_a(rotation).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a), region.func_201674_k());
            }
        }
    }

    private BlockPos adjustForRotation(BlockPos position, BlockPos size, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return position;
            }
            case CLOCKWISE_90: {
                return position.func_177982_a(size.func_177952_p() - 1, 0, 0);
            }
            case CLOCKWISE_180: {
                return position.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return position.func_177982_a(0, 0, size.func_177958_n() - 1);
            }
        }
        DivineRPG.LOGGER.warn("Invalid structure rotation passed in somehow, please report this.");
        return position;
    }
}

