/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.arcana;

import divinerpg.DivineRPG;
import divinerpg.entities.arcana.EntityCaptainMerik;
import divinerpg.entities.arcana.EntityDatticon;
import divinerpg.entities.arcana.EntityKazari;
import divinerpg.entities.arcana.EntityLeorna;
import divinerpg.entities.arcana.EntityLordVatticus;
import divinerpg.entities.arcana.EntityWarGeneral;
import divinerpg.entities.arcana.EntityZelus;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.StructureRegistry;
import divinerpg.util.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ArcanaPieces {
    public static void addStructure(TemplateManager manager, BlockPos pos, Rotation rotation, List<StructurePiece> piece, ResourceLocation location) {
        piece.add((StructurePiece)new Piece(manager, location, pos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation templateLocation;
        private final Rotation rotation;

        public Piece(TemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(StructureRegistry.Pieces.ARCANA_PIECE, 0);
            this.templateLocation = location;
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.loadTemplate(manager);
        }

        public Piece(TemplateManager manager, CompoundNBT nbt) {
            super(StructureRegistry.Pieces.ARCANA_PIECE, nbt);
            this.templateLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.templateLocation.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String data, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox box) {
            switch (data) {
                case "CaptainMerik": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityCaptainMerik(EntityRegistry.CAPTAIN_MERIK, (World)world.func_201672_e()));
                    break;
                }
                case "Datticon": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityDatticon(EntityRegistry.DATTICON, (World)world.func_201672_e()));
                    break;
                }
                case "Kazari": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityKazari(EntityRegistry.KAZARI, (World)world.func_201672_e()));
                    break;
                }
                case "Leorna": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityLeorna(EntityRegistry.LEORNA, (World)world.func_201672_e()));
                    break;
                }
                case "LordVatticus": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityLordVatticus(EntityRegistry.LORD_VATTICUS, (World)world.func_201672_e()));
                    break;
                }
                case "WarGeneral": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityWarGeneral(EntityRegistry.WAR_GENERAL, (World)world.func_201672_e()));
                    break;
                }
                case "Zelus": {
                    Utils.spawnPersistentEntity((World)world.func_201672_e(), pos, (LivingEntity)new EntityZelus(EntityRegistry.ZELUS, (World)world.func_201672_e()));
                    break;
                }
                default: {
                    DivineRPG.LOGGER.warn("Unexpected data marker: " + data + " in a structure, please report this.");
                }
            }
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_185779_df) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
            }
        }

        public boolean func_230383_a_(ISeedReader reader, StructureManager manager, ChunkGenerator chunkGenerator, Random rand, MutableBoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            BlockPos blockpos1 = this.field_186178_c;
            int i = reader.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, i - 90 - 2, 0);
            boolean flag = super.func_230383_a_(reader, manager, chunkGenerator, rand, box, chunkPos, pos);
            this.field_186178_c = blockpos2;
            return flag;
        }
    }
}

