/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.arcana;

import divinerpg.DivineRPG;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

public class ArcanaStructureHandler {
    protected String structureName;

    public ArcanaStructureHandler(String name) {
        this.structureName = name;
    }

    public String getName() {
        return this.structureName;
    }

    public boolean generateWithRotation(ServerWorld world, Random rand, BlockPos pos, Rotation rotation) {
        BlockPos size = this.getSize((World)world);
        BlockPos adjustedPosition = this.adjustForRotation(pos, size, rotation);
        Template template = this.load((World)world);
        if (template != null) {
            template.func_237144_a_((IServerWorld)world, adjustedPosition, new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_186220_a(rotation).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a), rand);
            List map = template.func_215386_a(pos, new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_186220_a(rotation).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a), Blocks.field_185779_df, true);
            Iterator var16 = map.iterator();
            if (var16.hasNext()) {
                this.handleDataMarkers((World)world, rand, var16);
            }
        }
        return true;
    }

    private BlockPos adjustForRotation(BlockPos position, BlockPos size, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return position;
            }
            case CLOCKWISE_90: {
                return position.func_177982_a(size.func_177952_p() - 1, 0, 0);
            }
            case CLOCKWISE_180: {
                return position.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return position.func_177982_a(0, 0, size.func_177958_n() - 1);
            }
        }
        DivineRPG.LOGGER.warn("Invalid structure rotation passed in somehow, please report this.");
        return position;
    }

    public BlockPos getSize(World world) {
        Template template = this.load(world);
        if (template != null) {
            return template.func_186259_a();
        }
        return null;
    }

    public void handleDataMarkers(World world, Random random, Iterator iterator) {
    }

    @Nullable
    private Template load(World world) {
        ResourceLocation location = new ResourceLocation("divinerpg", this.structureName);
        return world.func_73046_m().func_71218_a(world.func_234923_W_()).func_184163_y().func_200219_b(location);
    }
}

