/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.arcana;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public final class UnionFind<T> {
    private final Map<T, Link<T>> elems = new HashMap<T, Link<T>>();

    public UnionFind() {
    }

    public UnionFind(Collection<? extends T> elems) {
        for (T elem : elems) {
            this.add(elem);
        }
    }

    public boolean add(T elem) {
        if (elem == null) {
            throw new NullPointerException("UnionFind does not support null.");
        }
        if (this.elems.containsKey(elem)) {
            return false;
        }
        this.elems.put(elem, new Link<T>(elem));
        return true;
    }

    public T find(T elem) {
        if (!this.elems.containsKey(elem)) {
            throw new NoSuchElementException(elem + " is not an element.");
        }
        return this.recFind(elem);
    }

    private T recFind(T elem) {
        Link<T> info = this.elems.get(elem);
        if (info.parent.equals(elem)) {
            return elem;
        }
        info.parent = this.recFind(info.parent);
        return info.parent;
    }

    public void union(T one, T two) {
        Link<T> twoLink;
        Link<T> oneLink = this.elems.get(this.find(one));
        if (oneLink == (twoLink = this.elems.get(this.find(two)))) {
            return;
        }
        if (oneLink.rank > twoLink.rank) {
            twoLink.parent = oneLink.parent;
        } else if (oneLink.rank < twoLink.rank) {
            oneLink.parent = twoLink.parent;
        } else {
            twoLink.parent = oneLink.parent;
            ++oneLink.rank;
        }
    }

    private static final class Link<T> {
        public T parent;
        public int rank = 0;

        Link(T parent) {
            this.parent = parent;
        }
    }
}

