/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.structure;

import com.mojang.serialization.Codec;
import divinerpg.world.gen.structure.structures.HutStructure;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DivineStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"divinerpg");
    public static final RegistryObject<Structure<NoFeatureConfig>> HUT = STRUCTURES.register("hut", () -> new HutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void noise() {
        Structure.field_236365_a_.put((Object)"hut", (Object)HUT.get());
        WorldGenRegistries.field_243658_j.forEach(settings -> settings.func_236108_a_().func_236195_a_().put(HUT.get(), new StructureSeparationSettings(65, 32, 427227012)));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Configured.registerStructures();
            DivineStructures.noise();
        });
    }

    public static int getYPositionForFeature(int x, int z, ChunkGenerator chunkGen) {
        Rotation bzj5 = Rotation.func_222466_a((Random)new Random(x + z * 1024));
        int integer3 = 5;
        int integer4 = 5;
        if (bzj5 == Rotation.CLOCKWISE_90) {
            integer3 = -5;
        } else if (bzj5 == Rotation.CLOCKWISE_180) {
            integer3 = -5;
            integer4 = -5;
        } else if (bzj5 == Rotation.COUNTERCLOCKWISE_90) {
            integer4 = -5;
        }
        int integer7 = chunkGen.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        int integer8 = chunkGen.func_222531_c(x, z + integer4, Heightmap.Type.WORLD_SURFACE_WG);
        int integer9 = chunkGen.func_222531_c(x + integer3, z, Heightmap.Type.WORLD_SURFACE_WG);
        int integer10 = chunkGen.func_222531_c(x + integer3, z + integer4, Heightmap.Type.WORLD_SURFACE_WG);
        return Math.min(Math.min(integer7, integer8), Math.min(integer9, integer10));
    }

    public static final class Configured {
        public static final StructureFeature<?, ?> HUT = ((Structure)HUT.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);

        private static <FC extends IFeatureConfig> void register(String name, StructureFeature<FC, ?> stuctureFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("divinerpg", name), stuctureFeature);
        }

        public static void registerStructures() {
            Configured.register("hut", HUT);
        }
    }
}

