/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import divinerpg.world.gen.piece.ApalachiaPiece;
import divinerpg.world.gen.structure.DivineStructures;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ApalachiaStructures
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of();
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of();

    public ApalachiaStructures(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            if (!chunkGenerator.func_230348_a_(chunkX = chunkX * 16 + this.field_214631_d.nextInt(16), chunkZ = chunkZ * 16 + this.field_214631_d.nextInt(16)).func_180495_p(new BlockPos(chunkX, DivineStructures.getYPositionForFeature(chunkX, chunkZ, chunkGenerator) - 2, chunkZ)).func_196958_f()) {
                this.field_75075_a.add(new ApalachiaPiece.Piece(templateManagerIn, new BlockPos(chunkX, DivineStructures.getYPositionForFeature(chunkX, chunkZ, chunkGenerator) - 1, chunkZ), Rotation.func_222466_a((Random)this.field_214631_d)));
                this.func_202500_a();
            }
        }
    }
}

