/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import divinerpg.world.gen.piece.IceikaDungeonPiece;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class IceikaDungeonStructures
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of();
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of();

    public IceikaDungeonStructures(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        return topBlock.func_204520_s().func_206888_e();
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230366_a_(ISeedReader reader, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos chunkPos) {
            super.func_230366_a_(reader, structureManager, generator, random, box, chunkPos);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int structureY;
            ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
            int structureX = chunkpos.func_180334_c() + this.field_214631_d.nextInt(16);
            int structureZ = chunkpos.func_180333_d() + this.field_214631_d.nextInt(16);
            int seaLevel = chunkGenerator.func_230356_f_();
            IBlockReader reader = chunkGenerator.func_230348_a_(structureX, structureZ);
            BlockPos.Mutable pos = new BlockPos.Mutable(structureX, structureY, structureZ);
            for (structureY = seaLevel + this.field_214631_d.nextInt(chunkGenerator.func_230355_e_() - seaLevel); structureY > seaLevel; --structureY) {
                BlockState blockstate = reader.func_180495_p((BlockPos)pos);
                pos.func_189536_c(Direction.DOWN);
                BlockState state = reader.func_180495_p((BlockPos)pos);
                if (blockstate.func_203425_a(Blocks.field_150350_a) && state.func_224755_d(reader, (BlockPos)pos, Direction.UP)) break;
            }
            if (structureY > seaLevel) {
                Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
                this.field_75075_a.add(new IceikaDungeonPiece.Piece(templateManagerIn, new BlockPos(structureX, structureY - this.field_214631_d.nextInt(20) - 15, structureZ), rotation));
                this.func_202500_a();
            }
        }
    }
}

