/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import divinerpg.registries.BlockRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MortumStructures
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of();
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of();

    public MortumStructures(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int y;
            int x = chunkX * 16 + 8;
            int z = chunkZ * 16 + 8;
            int sl = chunkGenerator.func_230356_f_();
            BlockPos blockpos = new BlockPos(x, y, z);
            IBlockReader blockReader = chunkGenerator.func_230348_a_(blockpos.func_177958_n(), blockpos.func_177952_p());
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
            for (y = sl + this.field_214631_d.nextInt(chunkGenerator.func_230355_e_() - 2 - sl); y > sl; --y) {
                BlockState blockstate = blockReader.func_180495_p((BlockPos)blockpos$mutable);
                blockpos$mutable.func_189536_c(Direction.DOWN);
                BlockState blockstate1 = blockReader.func_180495_p((BlockPos)blockpos$mutable);
                if (blockstate.func_203425_a(Blocks.field_150350_a) && (blockstate1.func_203425_a(BlockRegistry.mortumGrass) || blockstate1.func_224755_d(blockReader, (BlockPos)blockpos$mutable, Direction.UP))) break;
            }
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("divinerpg", "twilight/mortum")), 5), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)new BlockPos(x, y, z), (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.func_202500_a();
        }
    }
}

