/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import divinerpg.blocks.base.BlockModLeaves;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class ApalachiaTreeFeature
extends DivineTreeFeature {
    public ApalachiaTreeFeature(Supplier<SaplingBlock> saplingBlock) {
        super(saplingBlock);
    }

    @Override
    protected boolean gen(ISeedReader world, Random rand, BlockPos pos) {
        if (this.canSustain(world, pos)) {
            int extraHeight;
            int treeHeight = rand.nextInt(15);
            int treeType = rand.nextInt(13);
            switch (treeType) {
                case 0: 
                case 1: {
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    treeHeight = 3 + rand.nextInt(3);
                    extraHeight = treeHeight + 4;
                }
            }
            if (this.heightCheck(world, pos, extraHeight, 1)) {
                BlockState log = BlockRegistry.apalachiaLog.func_176223_P();
                BlockState leaves = (BlockState)BlockRegistry.apalachiaLeaves.func_176223_P().func_206870_a((Property)BlockModLeaves.field_208494_a, (Comparable)Integer.valueOf(1));
                if (treeType != 12) {
                    this.grow(world, pos, log, 0, treeHeight);
                }
                switch (treeType) {
                    case 0: {
                        this.grow(world, pos, leaves, treeHeight - 1, 2, 0, false, 2);
                    }
                    case 1: {
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight + 1, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight, 1, 1);
                        this.grow(world, pos, leaves, treeHeight + 1, extraHeight);
                        break;
                    }
                    case 2: {
                        this.grow(world, pos, leaves, treeHeight - 1, 1, 1, false, 2);
                    }
                    case 3: {
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight + 1, extraHeight);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.grow(world, pos, leaves, treeHeight + 1, extraHeight);
                        this.grow(world, pos, leaves, treeHeight - 2, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight + 1, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight + 1, 2, 0);
                        this.grow(world, pos, leaves, treeHeight, 2, 1);
                        this.grow(world, pos, leaves, treeHeight, 2, -1);
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight, 1, 0);
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight - 1, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight, 1, 1);
                        if (treeType == 8 || treeType == 9) break;
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight, 2, offset);
                        }
                        break;
                    }
                    default: {
                        this.grow(world, pos, log, -2, -1, true);
                        this.grow(world, pos, log, -2, -1, 1, 0, true);
                        this.grow(world, pos, log, -1, 1, 1, true);
                        this.grow(world, pos, log, -1, 0, 2, 0, true);
                        this.grow(world, pos, log, -1, 1, 2, -1, true);
                        this.grow(world, pos, log, -1, 1, 2, 1, true);
                        this.grow(world, pos, log, -1, 2, 2, true);
                        this.grow(world, pos, log, -1, 3, 0, true);
                        this.grow(world, pos, leaves, 1, 2, 0);
                        this.grow(world, pos, log, 2, 2, 0);
                        this.grow(world, pos, log, 1, 3, 1, 1);
                        this.grow(world, pos, log, 2, treeHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight, treeHeight + 1, 1, 1);
                        this.grow(world, pos, log, extraHeight - 1, 1, 1);
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, extraHeight, 1, 1);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight + 1, extraHeight - 1, 2, offset);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

