/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;

public abstract class DivineTreeFeature
extends Feature<BlockStateFeatureConfig> {
    protected final Supplier<SaplingBlock> sapling;

    public DivineTreeFeature(Supplier<SaplingBlock> sapling) {
        super(BlockStateFeatureConfig.field_236455_a_);
        this.sapling = sapling;
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BlockStateFeatureConfig config) {
        return this.gen(reader, rand, pos);
    }

    protected abstract boolean gen(ISeedReader var1, Random var2, BlockPos var3);

    protected void setBlock(ISeedReader world, BlockPos pos, BlockState state) {
        this.setBlock(world, pos, state, false);
    }

    protected void setBlock(ISeedReader world, BlockPos pos, BlockState state, boolean replace) {
        if (replace && world.func_180495_p(pos.func_177977_b()) != Blocks.field_150357_h.func_176223_P() || this.hasSpace(world, pos)) {
            world.func_180501_a(pos, state, 0);
        }
    }

    protected void chanceSetBlock(ISeedReader world, BlockPos pos, BlockState state, int chance, boolean replace) {
        if (world.func_201674_k().nextInt(chance) == 0) {
            this.setBlock(world, pos, state, replace);
        }
    }

    protected void setBlockSensitive(ISeedReader world, BlockPos pos, BlockState state, int chance) {
        if (world.func_201674_k().nextInt(chance) == 0 && DivineTreeFeature.isAir(world, pos)) {
            world.func_180501_a(pos, state, 0);
        }
    }

    protected void growStar(ISeedReader world, BlockPos pos, BlockState firstState, BlockState secondState, int y, int width, int offset) {
        this.setBlock(world, pos.func_177982_a(width, y, offset), firstState, false);
        this.grow(world, pos.func_177982_a(width, y, offset), secondState, y, 1, 0);
        this.setBlock(world, pos.func_177982_a(-width, y, -offset), firstState, false);
        this.grow(world, pos.func_177982_a(-width, y, -offset), secondState, y, 1, 0);
        this.setBlock(world, pos.func_177982_a(offset, y, -width), firstState, false);
        this.grow(world, pos.func_177982_a(offset, y, -width), secondState, y, 1, 0);
        this.setBlock(world, pos.func_177982_a(-offset, y, width), firstState, false);
        this.grow(world, pos.func_177982_a(-offset, y, width), secondState, y, 1, 0);
    }

    protected void wideGrow(ISeedReader world, BlockPos pos, BlockState state, int y, int width, int offset) {
        this.setBlock(world, pos.func_177982_a(width + 1, y, offset), state);
        this.setBlock(world, pos.func_177982_a(-width, y, 1 - offset), state);
        this.setBlock(world, pos.func_177982_a(offset, y, -width), state);
        this.setBlock(world, pos.func_177982_a(1 - offset, y, width + 1), state);
    }

    protected void wideGrow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, int width, int offset) {
        ++maxY;
        while (minY < maxY) {
            this.setBlock(world, pos.func_177982_a(width + 1, minY, offset), state);
            this.setBlock(world, pos.func_177982_a(-width, minY, 1 - offset), state);
            this.setBlock(world, pos.func_177982_a(offset, minY, -width), state);
            this.setBlock(world, pos.func_177982_a(1 - offset, minY, width + 1), state);
            ++minY;
        }
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY) {
        this.grow(world, pos, state, minY, maxY, false, 1);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, boolean replace) {
        this.grow(world, pos, state, minY, maxY, replace, 1);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, boolean replace, int chance) {
        ++maxY;
        while (minY < maxY) {
            this.chanceSetBlock(world, pos.func_177982_a(0, minY, 0), state, chance, replace);
            ++minY;
        }
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int y, int width, int offset) {
        this.grow(world, pos, state, y, width, offset, false, 1);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int y, int width, int offset, boolean replace) {
        this.grow(world, pos, state, y, width, offset, replace, 1);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int y, int width, int offset, boolean replace, int chance) {
        this.chanceSetBlock(world, pos.func_177982_a(width, y, offset), state, chance, replace);
        this.chanceSetBlock(world, pos.func_177982_a(-width, y, -offset), state, chance, replace);
        this.chanceSetBlock(world, pos.func_177982_a(offset, y, -width), state, chance, replace);
        this.chanceSetBlock(world, pos.func_177982_a(-offset, y, width), state, chance, replace);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, int width, int offset) {
        this.grow(world, pos, state, minY, maxY, width, offset, false, 1);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, int width, int offset, int chance) {
        this.grow(world, pos, state, minY, maxY, width, offset, false, chance);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, int width, int offset, boolean replace) {
        this.grow(world, pos, state, minY, maxY, width, offset, replace, 1);
    }

    protected void grow(ISeedReader world, BlockPos pos, BlockState state, int minY, int maxY, int width, int offset, boolean replace, int chance) {
        ++maxY;
        while (minY < maxY) {
            this.chanceSetBlock(world, pos.func_177982_a(width, minY, offset), state, chance, replace);
            this.chanceSetBlock(world, pos.func_177982_a(-width, minY, -offset), state, chance, replace);
            this.chanceSetBlock(world, pos.func_177982_a(offset, minY, -width), state, chance, replace);
            this.chanceSetBlock(world, pos.func_177982_a(-offset, minY, width), state, chance, replace);
            ++minY;
        }
    }

    protected boolean hasSpace(ISeedReader world, BlockPos pos) {
        BlockState oldState = world.func_180495_p(pos);
        Block oldBlock = oldState.func_177230_c();
        return oldBlock.isAir(oldState, (IBlockReader)world, pos) || oldBlock.func_203417_a((ITag)BlockTags.field_206952_E) || oldBlock.func_203417_a((ITag)BlockTags.field_226149_I_);
    }

    protected static boolean isAir(ISeedReader world, BlockPos pos) {
        BlockState oldState = world.func_180495_p(pos);
        Block oldBlock = oldState.func_177230_c();
        return oldBlock.isAir(oldState, (IBlockReader)world, pos);
    }

    protected boolean heightCheck(ISeedReader world, BlockPos pos, int maxHeight, int width) {
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + maxHeight < 256) {
            for (int i = 1; i <= maxHeight; ++i) {
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < width; ++z) {
                        if (this.hasSpace(world, pos.func_177982_a(x, i, z))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean canSustain(ISeedReader world, BlockPos pos) {
        return TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos);
    }
}

