/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import divinerpg.blocks.base.BlockModLeaves;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class EdenTreeFeature
extends DivineTreeFeature {
    public EdenTreeFeature(Supplier<SaplingBlock> saplingBlock) {
        super(saplingBlock);
    }

    @Override
    protected boolean gen(ISeedReader world, Random rand, BlockPos pos) {
        if (this.canSustain(world, pos)) {
            int extraHeight;
            int treeHeight;
            int treeType = rand.nextInt(4);
            switch (treeType) {
                case 0: {
                    treeHeight = 3 + rand.nextInt(10);
                    extraHeight = treeHeight + 3 + rand.nextInt(2);
                    break;
                }
                case 1: {
                    treeHeight = 1 + rand.nextInt(3);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 2: {
                    treeHeight = 0 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    treeHeight = 3 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                }
            }
            if (this.heightCheck(world, pos, extraHeight, 1)) {
                BlockState log = BlockRegistry.edenLog.func_176223_P();
                BlockState leaves = (BlockState)BlockRegistry.edenLeaves.func_176223_P().func_206870_a((Property)BlockModLeaves.field_208494_a, (Comparable)Integer.valueOf(1));
                this.grow(world, pos, log, 0, treeHeight);
                switch (treeType) {
                    case 0: {
                        int bottomHeight = 1;
                        if (treeHeight > 9 || treeHeight == 9 && rand.nextBoolean()) {
                            ++bottomHeight;
                            this.grow(world, pos, log, 0, 0, 1, 0, false, 2);
                        }
                        this.grow(world, pos, leaves, bottomHeight, treeHeight + 1, 1, 0);
                        if (treeHeight > 7) {
                            this.grow(world, pos, leaves, bottomHeight + 2, treeHeight - 3, 2, 0);
                            this.grow(world, pos, leaves, treeHeight - 2, 2, 0, false, 2);
                            this.grow(world, pos, leaves, bottomHeight + 1, treeHeight - 2, 1, 1);
                            this.grow(world, pos, leaves, treeHeight - 1, 1, 1, false, 2);
                        } else {
                            if (treeHeight - 2 >= bottomHeight + 2) {
                                this.grow(world, pos, leaves, bottomHeight + 2, treeHeight - 2, 2, 0);
                            }
                            this.grow(world, pos, leaves, bottomHeight + 1, treeHeight - 1, 1, 1);
                            if (treeHeight < 7) {
                                this.grow(world, pos, leaves, treeHeight, 1, 1, false, 2);
                            }
                            if (treeHeight != 3 && treeHeight < 7) {
                                this.grow(world, pos, leaves, bottomHeight + 1, 2, 0, false, 2);
                                if (treeHeight < 6) {
                                    this.grow(world, pos, leaves, treeHeight - 1, 2, 0, false, 2);
                                }
                            }
                        }
                        this.grow(world, pos, leaves, treeHeight + 1, extraHeight);
                        break;
                    }
                    case 1: {
                        this.setBlock(world, pos.func_177982_a(0, -1, 0), log, true);
                        this.grow(world, pos, log, -1, 1, 0, true);
                        this.grow(world, pos, log, 0, 1, 0, false, 4);
                        this.setBlock(world, pos.func_177982_a(0, treeHeight + 1, 0), leaves);
                        this.chanceSetBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves, 2, false);
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight + 1, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 1, 1, 1, false, 2);
                        this.grow(world, pos, leaves, treeHeight, 1, 1);
                        this.grow(world, pos, leaves, treeHeight, 2, 0, false, 2);
                        break;
                    }
                    case 2: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight, 1, 0);
                        break;
                    }
                    default: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight - 2, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, 2, 2);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, offset);
                        }
                        this.grow(world, pos, leaves, treeHeight, 1, 1, false, 2);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

