/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import divinerpg.blocks.base.BlockModLeaves;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;

public class FrozenTreeFeature
extends DivineTreeFeature {
    public FrozenTreeFeature(Supplier<SaplingBlock> saplingBlock) {
        super(saplingBlock);
    }

    @Override
    protected boolean hasSpace(ISeedReader world, BlockPos pos) {
        BlockState oldState = world.func_180495_p(pos);
        Block oldBlock = oldState.func_177230_c();
        return oldBlock.isAir(oldState, (IBlockReader)world, pos) || oldBlock.func_203417_a((ITag)BlockTags.field_206952_E) || oldBlock.func_203417_a((ITag)BlockTags.field_226149_I_) || oldBlock.func_235332_a_(Blocks.field_150433_aE);
    }

    @Override
    protected boolean gen(ISeedReader world, Random rand, BlockPos pos) {
        if ((this.canSustain(world, pos) || world.func_180495_p(pos).func_203425_a(Blocks.field_150433_aE)) && !world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150355_j)) {
            int extraHeight;
            int treeHeight;
            int treeType = rand.nextInt(11);
            int width = 1;
            switch (treeType) {
                case 0: {
                    treeHeight = 2 + rand.nextInt(12);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 1: 
                case 2: {
                    treeHeight = 3 + rand.nextInt(6);
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 3: 
                case 4: {
                    treeHeight = 4 + rand.nextInt(9);
                    extraHeight = treeHeight + 2;
                    break;
                }
                default: {
                    width = 2;
                    treeHeight = 15 + rand.nextInt(20);
                    extraHeight = treeHeight + 2;
                }
            }
            if (this.heightCheck(world, pos, extraHeight, width)) {
                BlockState log = BlockRegistry.frozenLog.func_176223_P();
                BlockState leaves = (BlockState)BlockRegistry.brittleLeaves.func_176223_P().func_206870_a((Property)BlockModLeaves.field_208494_a, (Comparable)Integer.valueOf(1));
                this.grow(world, pos, log, -1, treeHeight);
                this.grow(world, pos, leaves, treeHeight + 1, extraHeight);
                if (width == 2) {
                    this.grow(world, pos.func_177982_a(1, 0, 0), log, -1, treeHeight);
                    this.grow(world, pos.func_177982_a(1, 0, 0), leaves, treeHeight + 1, extraHeight);
                    this.grow(world, pos.func_177982_a(0, 0, 1), log, -1, treeHeight);
                    this.grow(world, pos.func_177982_a(0, 0, 1), leaves, treeHeight + 1, extraHeight);
                    this.grow(world, pos.func_177982_a(1, 0, 1), log, -1, treeHeight);
                    this.grow(world, pos.func_177982_a(1, 0, 1), leaves, treeHeight + 1, extraHeight);
                }
                switch (treeType) {
                    case 0: {
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight + 1, 1, 0);
                        break;
                    }
                    case 1: 
                    case 2: {
                        int bottomHeight = rand.nextInt(2);
                        int wideHeight = 2 - bottomHeight + rand.nextInt(2);
                        boolean shift = rand.nextBoolean();
                        boolean even = treeHeight % 2 == bottomHeight ^ shift;
                        for (int y = 2 - bottomHeight; y <= treeHeight; ++y) {
                            if (y == wideHeight && treeType == 2 && wideHeight != extraHeight - 3) {
                                this.grow(world, pos, leaves, y, 1, 1);
                                this.grow(world, pos, leaves, y, 2, -1);
                                this.grow(world, pos, leaves, y, 2, 0);
                                this.grow(world, pos, leaves, y, 2, 1);
                                this.grow(world, pos, leaves, y, 2, 2);
                                for (int offset = -2; offset < 3; ++offset) {
                                    this.grow(world, pos, leaves, y, 3, offset);
                                }
                                if (!(y % 2 == bottomHeight ^ shift)) continue;
                                shift = !shift;
                                continue;
                            }
                            if (!(y % 2 == bottomHeight ^ shift)) continue;
                            this.grow(world, pos, leaves, y, 1, 1);
                            this.grow(world, pos, leaves, y, 2, -1);
                            this.grow(world, pos, leaves, y, 2, 0);
                            this.grow(world, pos, leaves, y, 2, 1);
                        }
                        this.grow(world, pos, log, treeHeight, treeHeight + rand.nextInt(even ? 2 : 3));
                        this.grow(world, pos, leaves, 2 - bottomHeight, treeHeight + (even ? 1 : 0), 1, 0);
                        this.grow(world, pos, leaves, extraHeight - (even ? 0 : 1), 1, 0);
                        break;
                    }
                    case 3: {
                        this.grow(world, pos, leaves, treeHeight - (width += rand.nextInt(2)), treeHeight + 1, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - width + 1, treeHeight, 1, 1);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight - width + 1, treeHeight, 2, offset);
                        }
                        break;
                    }
                    case 4: {
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight + 1, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight, 1, 1);
                        for (width = -2; width < 3; ++width) {
                            if (Math.abs(width) < 2) {
                                this.grow(world, pos, leaves, treeHeight - 2, treeHeight, 2, width);
                            }
                            this.grow(world, pos, leaves, treeHeight - 1, 3, width);
                        }
                        this.grow(world, pos, leaves, treeHeight - 1, 2, 2);
                        break;
                    }
                    case 5: {
                        width = treeHeight - 3 - rand.nextInt(3);
                        this.wideGrow(world, pos, leaves, width, treeHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, width, treeHeight, 1, 1);
                        extraHeight = treeHeight - 2;
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 1);
                        this.wideGrow(world, pos, leaves, width, extraHeight -= 2, 2, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 2);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 1);
                        break;
                    }
                    case 6: {
                        width = treeHeight - 15;
                        this.wideGrow(world, pos, leaves, treeHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, treeHeight, 1, 1);
                        extraHeight = treeHeight - 3;
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, 1);
                        --extraHeight;
                        while (extraHeight > treeHeight - 8) {
                            this.wideGrow(world, pos, leaves, extraHeight, 1, -1);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 0);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 1);
                            extraHeight -= 2;
                        }
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 1);
                        while (extraHeight > treeHeight - 11) {
                            this.wideGrow(world, pos, leaves, extraHeight, 2, -2);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, -1);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 2);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 3);
                            this.wideGrow(world, pos, leaves, extraHeight, 3, 0);
                            this.wideGrow(world, pos, leaves, extraHeight, 3, 1);
                            extraHeight -= 2;
                        }
                        extraHeight = width + 2;
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, -2);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 2);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 3);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 1);
                        this.wideGrow(world, pos, leaves, width + 1, 3, -2);
                        this.wideGrow(world, pos, leaves, width + 1, 3, -1);
                        this.wideGrow(world, pos, leaves, width + 1, 3, 2);
                        this.wideGrow(world, pos, leaves, width + 1, 3, 3);
                        this.wideGrow(world, pos, leaves, width + 1, 4, 0);
                        this.wideGrow(world, pos, leaves, width + 1, 4, 1);
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.wideGrow(world, pos, leaves, treeHeight + 1, 1, 0);
                        this.wideGrow(world, pos, leaves, treeHeight + 1, 1, 1);
                        int bottomHeight = 2 + rand.nextInt(5);
                        this.wideGrow(world, pos, leaves, bottomHeight, --treeHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, bottomHeight, treeHeight, 1, 1);
                        for (width = treeHeight - 1; width > bottomHeight; --width) {
                            int offset;
                            if ((treeHeight - width) % 3 != 0) {
                                this.wideGrow(world, pos, leaves, width, 1, -1);
                                for (offset = -1; offset < 3; ++offset) {
                                    this.wideGrow(world, pos, leaves, width, 2, offset);
                                }
                            }
                            if ((treeHeight - width) % 3 != 2) continue;
                            this.wideGrow(world, pos, leaves, width, 2, -2);
                            for (offset = -2; offset < 4; ++offset) {
                                this.wideGrow(world, pos, leaves, width, 3, offset);
                            }
                        }
                        break;
                    }
                    default: {
                        this.wideGrow(world, pos, leaves, extraHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, extraHeight, 1, 1);
                        int bottomHeight = 5 + rand.nextInt(10);
                        ++treeHeight;
                        int stage = 2;
                        while (treeHeight > bottomHeight) {
                            for (width = 1; width < stage; ++width) {
                                extraHeight = --treeHeight + 1 - (stage - width);
                                for (int offset = 1 - width; offset <= width; ++offset) {
                                    this.wideGrow(world, pos, leaves, extraHeight, treeHeight, width, offset);
                                }
                                this.wideGrow(world, pos, leaves, extraHeight, treeHeight, width - 1, width);
                            }
                            if (stage >= 6) continue;
                            ++stage;
                        }
                        break block5;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

