/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import divinerpg.blocks.base.BlockModLeaves;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class MortumTreeFeature
extends DivineTreeFeature {
    public MortumTreeFeature(Supplier<SaplingBlock> saplingBlock) {
        super(saplingBlock);
    }

    @Override
    protected boolean gen(ISeedReader world, Random rand, BlockPos pos) {
        if ((world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151578_c || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151577_b) && this.canSustain(world, pos)) {
            int extraHeight;
            int treeHeight;
            int treeType = rand.nextInt(4);
            switch (treeType) {
                case 0: {
                    treeHeight = 2 + rand.nextInt(4);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 1: {
                    treeHeight = 1 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 2: {
                    treeHeight = 0 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    treeHeight = 3 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                }
            }
            if (this.heightCheck(world, pos, extraHeight, 1)) {
                BlockState log = BlockRegistry.mortumLog.func_176223_P();
                BlockState leaves = (BlockState)BlockRegistry.mortumLeaves.func_176223_P().func_206870_a((Property)BlockModLeaves.field_208494_a, (Comparable)Integer.valueOf(1));
                this.grow(world, pos, log, 0, treeHeight);
                switch (treeType) {
                    case 0: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        extraHeight = 1 + rand.nextInt(2);
                        this.grow(world, pos, leaves, extraHeight, treeHeight, 1, 0);
                        this.grow(world, pos, leaves, extraHeight + 1, treeHeight - 1, 1, 1);
                        break;
                    }
                    case 1: {
                        this.setBlock(world, pos.func_177982_a(0, -1, 0), log, true);
                        this.grow(world, pos, log, -1, 1, 0, true);
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight - 1, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight, 1, 1);
                        break;
                    }
                    case 2: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight, 1, 0);
                        break;
                    }
                    default: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight - 2, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, 2, 2);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, offset);
                        }
                        this.grow(world, pos, leaves, treeHeight, 1, 1, false, 2);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

