/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import divinerpg.blocks.base.BlockModLeaves;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class SkythernTreeFeature
extends DivineTreeFeature {
    public SkythernTreeFeature(Supplier<SaplingBlock> saplingBlock) {
        super(saplingBlock);
    }

    @Override
    protected boolean gen(ISeedReader world, Random rand, BlockPos pos) {
        if (this.canSustain(world, pos)) {
            int extraHeight;
            int treeHeight;
            int treeType = rand.nextInt(10);
            int width = 1;
            switch (treeType) {
                case 0: {
                    treeHeight = 2 + rand.nextInt(12);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 1: 
                case 2: {
                    treeHeight = 3 + rand.nextInt(6);
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 3: 
                case 4: {
                    treeHeight = 4 + rand.nextInt(9);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    width = 2;
                    treeHeight = 15 + rand.nextInt(20);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 8: {
                    treeHeight = 13 + rand.nextInt(8);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    treeHeight = 3 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                }
            }
            if (this.heightCheck(world, pos, extraHeight, width)) {
                BlockState log = BlockRegistry.skythernLog.func_176223_P();
                BlockState leaves = (BlockState)BlockRegistry.skythernLeaves.func_176223_P().func_206870_a((Property)BlockModLeaves.field_208494_a, (Comparable)Integer.valueOf(1));
                this.grow(world, pos, log, 0, treeHeight);
                this.grow(world, pos, leaves, treeHeight + 1, extraHeight);
                if (width == 2) {
                    this.grow(world, pos.func_177982_a(1, 0, 0), log, 0, treeHeight);
                    this.grow(world, pos.func_177982_a(1, 0, 0), leaves, treeHeight + 1, extraHeight);
                    this.grow(world, pos.func_177982_a(0, 0, 1), log, 0, treeHeight);
                    this.grow(world, pos.func_177982_a(0, 0, 1), leaves, treeHeight + 1, extraHeight);
                    this.grow(world, pos.func_177982_a(1, 0, 1), log, 0, treeHeight);
                    this.grow(world, pos.func_177982_a(1, 0, 1), leaves, treeHeight + 1, extraHeight);
                }
                switch (treeType) {
                    case 0: {
                        this.grow(world, pos, leaves, treeHeight - 1, treeHeight + 1, 1, 0);
                        break;
                    }
                    case 1: 
                    case 2: {
                        int bottomHeight = rand.nextInt(2);
                        int wideHeight = 2 - bottomHeight + rand.nextInt(2);
                        boolean shift = rand.nextBoolean();
                        boolean even = treeHeight % 2 == bottomHeight ^ shift;
                        for (int y = 2 - bottomHeight; y <= treeHeight; ++y) {
                            if (y == wideHeight && treeType == 2 && wideHeight != extraHeight - 3) {
                                this.grow(world, pos, leaves, y, 1, 1);
                                this.grow(world, pos, leaves, y, 2, -1);
                                this.grow(world, pos, leaves, y, 2, 0);
                                this.grow(world, pos, leaves, y, 2, 1);
                                this.grow(world, pos, leaves, y, 2, 2);
                                for (int offset = -2; offset < 3; ++offset) {
                                    this.grow(world, pos, leaves, y, 3, offset);
                                }
                                if (!(y % 2 == bottomHeight ^ shift)) continue;
                                shift = !shift;
                                continue;
                            }
                            if (!(y % 2 == bottomHeight ^ shift)) continue;
                            this.grow(world, pos, leaves, y, 1, 1);
                            this.grow(world, pos, leaves, y, 2, -1);
                            this.grow(world, pos, leaves, y, 2, 0);
                            this.grow(world, pos, leaves, y, 2, 1);
                        }
                        this.grow(world, pos, log, treeHeight, treeHeight + rand.nextInt(even ? 2 : 3));
                        this.grow(world, pos, leaves, 2 - bottomHeight, treeHeight + (even ? 1 : 0), 1, 0);
                        this.grow(world, pos, leaves, extraHeight - (even ? 0 : 1), 1, 0);
                        break;
                    }
                    case 3: {
                        this.grow(world, pos, leaves, treeHeight - (width += rand.nextInt(2)), treeHeight + 1, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - width + 1, treeHeight, 1, 1);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight - width + 1, treeHeight, 2, offset);
                        }
                        break;
                    }
                    case 4: {
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight + 1, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight, 1, 1);
                        for (width = -2; width < 3; ++width) {
                            if (Math.abs(width) < 2) {
                                this.grow(world, pos, leaves, treeHeight - 2, treeHeight, 2, width);
                            }
                            this.grow(world, pos, leaves, treeHeight - 1, 3, width);
                        }
                        this.grow(world, pos, leaves, treeHeight - 1, 2, 2);
                        break;
                    }
                    case 5: {
                        width = treeHeight - 3 - rand.nextInt(3);
                        this.wideGrow(world, pos, leaves, width, treeHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, width, treeHeight, 1, 1);
                        extraHeight = treeHeight - 2;
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 1);
                        this.wideGrow(world, pos, leaves, width, extraHeight -= 2, 2, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 2);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 1);
                        break;
                    }
                    case 6: {
                        width = treeHeight - 15;
                        this.wideGrow(world, pos, leaves, treeHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, treeHeight, 1, 1);
                        extraHeight = treeHeight - 3;
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, 1);
                        --extraHeight;
                        while (extraHeight > treeHeight - 8) {
                            this.wideGrow(world, pos, leaves, extraHeight, 1, -1);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 0);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 1);
                            extraHeight -= 2;
                        }
                        this.wideGrow(world, pos, leaves, width, extraHeight, 1, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 1);
                        while (extraHeight > treeHeight - 11) {
                            this.wideGrow(world, pos, leaves, extraHeight, 2, -2);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, -1);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 2);
                            this.wideGrow(world, pos, leaves, extraHeight, 2, 3);
                            this.wideGrow(world, pos, leaves, extraHeight, 3, 0);
                            this.wideGrow(world, pos, leaves, extraHeight, 3, 1);
                            extraHeight -= 2;
                        }
                        extraHeight = width + 2;
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, -2);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, -1);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 2);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 2, 3);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 0);
                        this.wideGrow(world, pos, leaves, width, extraHeight, 3, 1);
                        this.wideGrow(world, pos, leaves, width + 1, 3, -2);
                        this.wideGrow(world, pos, leaves, width + 1, 3, -1);
                        this.wideGrow(world, pos, leaves, width + 1, 3, 2);
                        this.wideGrow(world, pos, leaves, width + 1, 3, 3);
                        this.wideGrow(world, pos, leaves, width + 1, 4, 0);
                        this.wideGrow(world, pos, leaves, width + 1, 4, 1);
                        break;
                    }
                    case 7: {
                        width = treeHeight - 2;
                        this.wideGrow(world, pos, leaves, width, treeHeight, 1, 0);
                        this.wideGrow(world, pos, leaves, width, treeHeight, 1, 1);
                        this.wideGrow(world, pos, leaves, width, treeHeight - 1, 1, -1);
                        this.wideGrow(world, pos, leaves, width, treeHeight - 1, 2, 0);
                        this.wideGrow(world, pos, leaves, width, treeHeight - 1, 2, 1);
                        this.wideGrow(world, pos, leaves, width, 2, 2);
                        this.wideGrow(world, pos, leaves, width, 2, -1);
                        this.wideGrow(world, pos, leaves, width, 2, -2);
                        this.wideGrow(world, pos, leaves, width, 3, 0);
                        this.wideGrow(world, pos, leaves, width, 3, 1);
                        break;
                    }
                    case 8: {
                        this.grow(world, pos, log, treeHeight - 10, treeHeight - 9, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 8, treeHeight - 7, 1, 0);
                        this.grow(world, pos, log, treeHeight - 6, treeHeight - 5, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 4, treeHeight - 2, 1, 0);
                        this.grow(world, pos, leaves, treeHeight, 1, 0);
                        this.grow(world, pos, log, treeHeight - 8, 2, 0);
                        this.grow(world, pos, log, treeHeight - 8, 1, 1);
                        this.grow(world, pos, log, treeHeight - 4, 2, 0);
                        this.grow(world, pos, leaves, treeHeight - 7, treeHeight - 3, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 7, treeHeight - 3, 2, 0);
                        this.grow(world, pos, leaves, treeHeight - 7, treeHeight - 6, 2, 1);
                        this.grow(world, pos, leaves, treeHeight - 7, treeHeight - 6, 2, -1);
                        this.grow(world, pos, leaves, treeHeight - 4, 2, 1);
                        this.grow(world, pos, leaves, treeHeight - 4, 2, -1);
                        this.grow(world, pos, log, treeHeight - 7, 2, 2);
                        this.grow(world, pos, leaves, treeHeight - 6, 2, 2);
                        this.grow(world, pos, log, treeHeight - 7, 3, 0);
                        this.grow(world, pos, leaves, treeHeight - 6, 3, 0);
                        this.grow(world, pos, leaves, treeHeight - 4, 3, 0);
                        this.grow(world, pos, log, treeHeight - 7, 3, 3);
                        this.grow(world, pos, leaves, treeHeight - 7, 3, -2);
                        this.grow(world, pos, leaves, treeHeight - 7, 3, -1);
                        this.grow(world, pos, leaves, treeHeight - 7, 3, 1);
                        this.grow(world, pos, leaves, treeHeight - 7, 3, 2);
                        this.grow(world, pos, leaves, treeHeight - 6, 3, 3);
                        this.grow(world, pos, log, treeHeight - 7, 4, 0);
                        this.grow(world, pos, leaves, treeHeight - 6, 4, 0);
                        this.grow(world, pos, leaves, treeHeight - 7, 4, -3);
                        this.grow(world, pos, leaves, treeHeight - 7, 4, -1);
                        this.grow(world, pos, leaves, treeHeight - 7, 4, 1);
                        this.grow(world, pos, leaves, treeHeight - 7, 4, 3);
                        this.grow(world, pos, leaves, treeHeight - 7, 5, 0);
                        break;
                    }
                    default: {
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight - 2, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, 2, 2);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, offset);
                        }
                        this.grow(world, pos, leaves, treeHeight, 1, 1, false, 2);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

