/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.gen.tree.feature;

import divinerpg.blocks.base.BlockModLeaves;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class WildwoodTreeFeature
extends DivineTreeFeature {
    private static final BlockState leaves = (BlockState)BlockRegistry.wildwoodLeaves.func_176223_P().func_206870_a((Property)BlockModLeaves.field_208494_a, (Comparable)Integer.valueOf(1));
    private static final BlockState northVines = (BlockState)BlockRegistry.wildwoodVine.func_176223_P().func_206870_a((Property)SixWayBlock.field_196488_a, (Comparable)Boolean.valueOf(true));
    private static final BlockState eastVines = (BlockState)BlockRegistry.wildwoodVine.func_176223_P().func_206870_a((Property)SixWayBlock.field_196490_b, (Comparable)Boolean.valueOf(true));
    private static final BlockState southVines = (BlockState)BlockRegistry.wildwoodVine.func_176223_P().func_206870_a((Property)SixWayBlock.field_196492_c, (Comparable)Boolean.valueOf(true));
    private static final BlockState westVines = (BlockState)BlockRegistry.wildwoodVine.func_176223_P().func_206870_a((Property)SixWayBlock.field_196495_y, (Comparable)Boolean.valueOf(true));
    private static final BlockState log = BlockRegistry.wildwoodLog.func_176223_P();

    public WildwoodTreeFeature(Supplier<SaplingBlock> sapling) {
        super(sapling);
    }

    private void growLeavesWithVines(ISeedReader world, BlockPos pos, int y, int width, int offset, int leavesChance, int vineChance) {
        this.chanceSetBlock(world, pos.func_177982_a(width, y, offset), leaves, leavesChance, false);
        if (!WildwoodTreeFeature.isAir(world, pos.func_177982_a(width, y, offset))) {
            this.setBlockSensitive(world, pos.func_177982_a(width + 1, y, offset), westVines, vineChance);
        }
        this.chanceSetBlock(world, pos.func_177982_a(-width, y, -offset), leaves, leavesChance, false);
        if (!WildwoodTreeFeature.isAir(world, pos.func_177982_a(-width, y, -offset))) {
            this.setBlockSensitive(world, pos.func_177982_a(-width - 1, y, -offset), eastVines, vineChance);
        }
        this.chanceSetBlock(world, pos.func_177982_a(offset, y, -width), leaves, leavesChance, false);
        if (!WildwoodTreeFeature.isAir(world, pos.func_177982_a(offset, y, -width))) {
            this.setBlockSensitive(world, pos.func_177982_a(offset, y, -width - 1), southVines, vineChance);
        }
        this.chanceSetBlock(world, pos.func_177982_a(-offset, y, width), leaves, leavesChance, false);
        if (!WildwoodTreeFeature.isAir(world, pos.func_177982_a(-offset, y, width))) {
            this.setBlockSensitive(world, pos.func_177982_a(-offset, y, width + 1), northVines, vineChance);
        }
    }

    private void growVines(ISeedReader world, BlockPos pos, int minY, int maxY, int width, int offset, int chance) {
        while (minY < maxY + 1) {
            this.setBlockSensitive(world, pos.func_177982_a(width, minY, offset), westVines, chance);
            this.setBlockSensitive(world, pos.func_177982_a(-width, minY, -offset), eastVines, chance);
            this.setBlockSensitive(world, pos.func_177982_a(offset, minY, -width), southVines, chance);
            this.setBlockSensitive(world, pos.func_177982_a(-offset, minY, width), northVines, chance);
            ++minY;
        }
    }

    private void growTheLeaves(ISeedReader world, BlockPos pos, int minY, int maxY, int vineChance) {
        for (int offset = -1; offset < 2; offset = (int)((byte)(offset + 1))) {
            this.grow(world, pos, leaves, minY, maxY, 2, offset);
            this.growVines(world, pos, minY, maxY, 3, offset, vineChance);
        }
    }

    @Override
    protected boolean gen(ISeedReader world, Random rand, BlockPos pos) {
        if (this.canSustain(world, pos)) {
            int extraHeight;
            int treeHeight;
            int treeType = rand.nextInt(7);
            switch (treeType) {
                case 0: {
                    treeHeight = 1 + rand.nextInt(4);
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 1: {
                    treeHeight = 6 + rand.nextInt(4);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 2: {
                    if (rand.nextInt(32) == 0) {
                        treeHeight = 15;
                        extraHeight = 16;
                        break;
                    }
                    treeHeight = 5 + rand.nextInt(2);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 3: {
                    treeHeight = 7 + rand.nextInt(4);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 4: {
                    treeHeight = 1 + rand.nextInt(2);
                    extraHeight = treeHeight + 1;
                    break;
                }
                case 5: {
                    treeHeight = 2 + rand.nextInt(6);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    treeHeight = 3 + rand.nextInt(3);
                    extraHeight = treeHeight + 1;
                }
            }
            if (this.heightCheck(world, pos, extraHeight, 1)) {
                switch (treeType) {
                    case 0: {
                        int offset;
                        this.grow(world, pos, log, -2, 1, 0, true);
                        for (offset = -1; offset < 2; ++offset) {
                            this.grow(world, pos, log, -2, 2, offset, true);
                        }
                        this.grow(world, pos, log, -2, treeHeight, true);
                        this.grow(world, pos, log, -1, 1, 1, 0, true);
                        this.grow(world, pos, log, -2, 0, 1, 1, true);
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight, treeHeight + 2, 1, 0);
                        this.grow(world, pos, leaves, treeHeight + 1, treeHeight + 2, 1, 1);
                        this.growTheLeaves(world, pos, treeHeight + 1, treeHeight + 1, 2);
                        this.grow(world, pos, leaves, treeHeight, 1, 1, false, 2);
                        this.grow(world, pos, leaves, treeHeight + 1, 2, 2, false, 2);
                        for (offset = -1; offset < 2; ++offset) {
                            this.growLeavesWithVines(world, pos, treeHeight, 2, offset, 2, 2);
                        }
                        break;
                    }
                    case 1: {
                        this.grow(world, pos, log, -1, 3, 1, true);
                        this.grow(world, pos, log, -1, 3, -1, true);
                        this.grow(world, pos, log, -2, -1, 2, 2, true);
                        this.grow(world, pos, log, -treeHeight / 2, treeHeight, true);
                        this.grow(world, pos, log, -treeHeight / 3, 1, 1, 0);
                        this.grow(world, pos, log, -treeHeight / 4, 0, 1, 1);
                        this.grow(world, pos, log, -1, 0, 2, 0, true);
                        this.growVines(world, pos, 0, 0, 3, 0, 1);
                        this.growVines(world, pos, 0, 0, 2, 1, 2);
                        this.growVines(world, pos, 0, 0, 2, -1, 2);
                        int w = rand.nextInt(2);
                        this.grow(world, pos, log, treeHeight - 1, 1, 0, false);
                        this.grow(world, pos, log, treeHeight - 3, 1, 0, false);
                        if (w == 1) {
                            this.grow(world, pos, log, treeHeight - 3, 2, 0, false);
                        }
                        this.grow(world, pos, log, treeHeight - 4, 2 + w, 1, false);
                        this.grow(world, pos, log, treeHeight - 4, 2 + w, -1, false);
                        this.grow(world, pos, log, treeHeight - 5, 3 + w, 0, false);
                        this.grow(world, pos, log, treeHeight - 5, 3 + w, 2, false);
                        this.grow(world, pos, log, treeHeight - 5, 3 + w, -2, false);
                        this.growVines(world, pos, treeHeight - 5, treeHeight - 5, -2 - w, 0, 2);
                        this.growVines(world, pos, treeHeight - 5, treeHeight - 5, -2 - w, 2, 2);
                        this.growVines(world, pos, treeHeight - 5, treeHeight - 5, -2 - w, -2, 2);
                        this.growVines(world, pos, treeHeight - 4, treeHeight - 4, -1 - w, 1, 2);
                        this.growVines(world, pos, treeHeight - 4, treeHeight - 4, -1 - w, -1, 2);
                        this.grow(world, pos, leaves, treeHeight - 5, 3 + w, 1);
                        this.grow(world, pos, leaves, treeHeight - 5, 3 + w, -1);
                        if (w == 1) {
                            this.grow(world, pos, leaves, treeHeight - 5, 4, 3);
                            this.grow(world, pos, leaves, treeHeight - 5, 4, -3);
                            this.grow(world, pos, leaves, treeHeight - 4, 3, 2);
                            this.grow(world, pos, leaves, treeHeight - 4, 3, -2);
                            this.grow(world, pos, leaves, treeHeight - 4, 3, 3);
                            this.grow(world, pos, leaves, treeHeight - 3, 2, 2);
                            this.grow(world, pos, leaves, treeHeight - 3, 2, 1);
                            this.grow(world, pos, leaves, treeHeight - 3, 2, -1);
                        } else {
                            this.grow(world, pos, leaves, treeHeight - 4, 2, 2);
                        }
                        this.grow(world, pos, leaves, treeHeight - 5, 3, 3);
                        this.growVines(world, pos.func_177982_a(0, treeHeight - 5, 0), 0, 0, 4, 3 + w, 2);
                        this.grow(world, pos, leaves, treeHeight - 3, treeHeight - 1, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, 0);
                        this.setBlock(world, pos.func_177982_a(0, treeHeight - 2, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight, 1, 0);
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        for (int i = -2; i < 3; i = (int)((byte)(i + 1))) {
                            this.grow(world, pos, leaves, treeHeight - 5, 4 + w, i);
                            this.growVines(world, pos, treeHeight - 5, treeHeight - 5, 5 + w, i, 2);
                            this.grow(world, pos, leaves, treeHeight - 4, 3 + w, i);
                            if (i <= -2 || i >= 2) continue;
                            this.grow(world, pos, leaves, treeHeight - 3, 2 + w, i);
                        }
                        break;
                    }
                    case 2: {
                        int i;
                        int trunkY = treeHeight / 3;
                        this.grow(world, pos, log, 0, trunkY);
                        if (treeHeight == 15) {
                            this.grow(world, pos, log, trunkY + 1, 1, 0);
                            this.grow(world, pos, log, trunkY + 2, 2, 1);
                            int offset = 1;
                            for (int y = trunkY + 3; y < treeHeight + 1; ++y) {
                                int width;
                                if (++offset == 2) {
                                    offset = -2;
                                    width = 2;
                                } else {
                                    width = 3;
                                }
                                this.grow(world, pos, log, y, width, offset);
                                this.grow(world, pos, leaves, y + 1, width, offset);
                                this.growLeavesWithVines(world, pos.func_177982_a(width, y, offset), 0, 1, 0, 1, 2);
                                this.growLeavesWithVines(world, pos.func_177982_a(-width, y, -offset), 0, 1, 0, 1, 2);
                                this.growLeavesWithVines(world, pos.func_177982_a(offset, y, -width), 0, 1, 0, 1, 2);
                                this.growLeavesWithVines(world, pos.func_177982_a(-offset, y, width), 0, 1, 0, 1, 2);
                            }
                            this.grow(world, pos, leaves, trunkY + 1, trunkY + 2);
                            this.grow(world, pos, leaves, trunkY + 2, 1, 0);
                            this.grow(world, pos, leaves, trunkY + 1, trunkY + 2, 1, 1);
                            this.grow(world, pos, leaves, trunkY + 1, trunkY + 2, 2, 0);
                            this.grow(world, pos, leaves, trunkY + 2, 3, 1);
                            this.grow(world, pos, leaves, trunkY + 2, 2, 2);
                            this.grow(world, pos, leaves, extraHeight, 3, offset);
                            break;
                        }
                        int length = treeHeight - trunkY;
                        int n = i = rand.nextInt(4) == 0 ? 0 : 1;
                        while (i < 3) {
                            if (i == 2) {
                                treeHeight -= rand.nextInt(3);
                            }
                            double stepX = (-3.0 + rand.nextDouble() * 7.0) / (double)length;
                            double stepZ = (-3.0 + rand.nextDouble() * 7.0) / (double)length;
                            double x = 0.0;
                            double z = 0.0;
                            for (int y = 1; y < length + 1; ++y) {
                                this.setBlock(world, pos.func_177963_a(x += stepX, (double)(trunkY + y), z += stepZ), log);
                                this.grow(world, pos.func_177963_a(x, (double)(trunkY + y), z), leaves, 0, 1, 0);
                                this.growLeavesWithVines(world, pos.func_177963_a(x, (double)(trunkY + y), z), 0, 1, 1, 2, 3);
                                if (y <= 1 || trunkY + y >= treeHeight) continue;
                                this.growLeavesWithVines(world, pos.func_177963_a(x, (double)(trunkY + y), z), 0, 2, 0, 3, 2);
                            }
                            this.setBlock(world, pos.func_177963_a(x, (double)extraHeight, z), leaves);
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        int destX = -3 + rand.nextInt(7);
                        int destZ = -3 + rand.nextInt(7);
                        double stepX = (double)destX / (double)(treeHeight + 1);
                        double stepZ = (double)destZ / (double)(treeHeight + 1);
                        double x = 0.0;
                        double z = 0.0;
                        for (int y = 1; y < treeHeight + 1; ++y) {
                            long pX = Math.round(x);
                            long pZ = Math.round(z);
                            this.setBlock(world, pos.func_177963_a((double)pX, (double)y, (double)pZ), log);
                            this.grow(world, pos.func_177963_a((double)pX, (double)y, (double)pZ), log, 0, 1, 0);
                            this.growVines(world, pos.func_177963_a((double)pX, (double)y, (double)pZ), 0, 0, 2, 0, 3);
                            x += stepX;
                            z += stepZ;
                        }
                        this.grow(world, pos, log, 2, 1, 0);
                        this.grow(world, pos, log, -1, 0, true);
                        this.grow(world, pos, log, 1, 2, 1, 1);
                        this.grow(world, pos, log, -2, 1, 2, 0, true);
                        this.grow(world, pos, log, -2, 0, 2, 2, true);
                        BlockPos p = pos.func_177982_a(destX, treeHeight, destZ);
                        this.setBlock(world, p, log);
                        this.setBlock(world, p.func_177982_a(0, 1, 0), leaves);
                        this.grow(world, p, leaves, 0, 1, 1, 0);
                        this.grow(world, p, log, 0, 1, 1);
                        this.grow(world, p, leaves, 1, 1, 1);
                        for (int i = -2; i < 2; ++i) {
                            if (Math.abs(i) == 1) {
                                this.grow(world, p, log, 0, 2, i);
                                this.grow(world, p, leaves, 1, 2, i);
                            } else {
                                this.grow(world, p, leaves, 0, 1, 2, i);
                            }
                            this.growLeavesWithVines(world, p, 0, 3, i, 1, 2);
                            this.growLeavesWithVines(world, p, -1, 3, i, 3, 1);
                        }
                        this.growLeavesWithVines(world, p, 0, 3, 2, 1, 2);
                        this.grow(world, p, leaves, 2, 1, 0);
                        this.setBlock(world, p.func_177982_a(0, 2, 0), leaves);
                        break;
                    }
                    case 4: {
                        this.grow(world, pos, log, 0, treeHeight, true);
                        this.grow(world, pos, leaves, treeHeight, 1, 0);
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        break;
                    }
                    case 5: {
                        this.grow(world, pos, log, -3, treeHeight - 5, 2, 0, true);
                        this.grow(world, pos, log, -2, -1, 1, 1, true);
                        this.grow(world, pos, log, treeHeight - 4, treeHeight - 3, 1, 0, true);
                        this.growVines(world, pos, treeHeight - 4, treeHeight - 3, 1, 1, 2);
                        pos = pos.func_177982_a(0, treeHeight - 4, 0);
                    }
                    default: {
                        this.grow(world, pos, log, 0, treeHeight);
                        this.setBlock(world, pos.func_177982_a(0, extraHeight, 0), leaves);
                        this.grow(world, pos, leaves, treeHeight - 2, extraHeight, 1, 0);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 1, 1);
                        this.grow(world, pos, leaves, treeHeight - 2, treeHeight - 1, 2, 2, 2);
                        this.growTheLeaves(world, pos, treeHeight - 2, treeHeight - 1, 4);
                        this.grow(world, pos, leaves, treeHeight, 1, 1, false, 2);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.growLeavesWithVines(world, pos, treeHeight - 3, 2, offset, 3, 1);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

