/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.surface;

import com.mojang.serialization.Codec;
import divinerpg.registries.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class IceikaSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected static final BlockState PACKED_ICE = Blocks.field_150403_cj.func_176223_P();
    protected static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    protected static final BlockState STONE = BlockRegistry.frozenStone.func_176223_P();
    protected static final BlockState DIRT = BlockRegistry.frozenDirt.func_176223_P();
    protected static final BlockState GRASS = BlockRegistry.frozenGrass.func_176223_P();
    protected static final BlockState AIR = Blocks.field_150350_a.func_176223_P();

    public IceikaSurfaceBuilder(Codec<SurfaceBuilderConfig> p_i232126_1_) {
        super(p_i232126_1_);
    }

    public void apply(Random random, IChunk chunk, Biome biome, int posX, int posZ, int startHeight, double noiseAmp, BlockState block, BlockState fluid, int sea, long seed, SurfaceBuilderConfig config) {
        this.apply(random, chunk, biome, posX, posZ, startHeight, noiseAmp, block, fluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), sea);
    }

    protected void apply(Random random, IChunk chunk, Biome biome, int p_206967_4_, int p_206967_5_, int p_206967_6_, double p_206967_7_, BlockState p_206967_9_, BlockState p_206967_10_, BlockState p_206967_11_, BlockState p_206967_12_, BlockState p_206967_13_, int p_206967_14_) {
        BlockState blockstate = p_206967_11_;
        BlockState blockstate1 = p_206967_12_;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = -1;
        int j = (int)(p_206967_7_ / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int k = p_206967_4_ & 0xF;
        int l = p_206967_5_ & 0xF;
        for (int i1 = p_206967_6_; i1 >= 0; --i1) {
            blockpos$mutable.func_181079_c(k, i1, l);
            BlockState blockstate2 = chunk.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate2.func_196958_f()) {
                i = -1;
                continue;
            }
            if (!blockstate2.func_203425_a(p_206967_9_.func_177230_c())) continue;
            if (i == -1) {
                if (j <= 0) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    blockstate1 = p_206967_9_;
                } else if (i1 >= p_206967_14_ - 4 && i1 <= p_206967_14_ + 1) {
                    blockstate = p_206967_11_;
                    blockstate1 = p_206967_12_;
                }
                if (i1 < p_206967_14_ && (blockstate == null || blockstate.func_196958_f())) {
                    blockstate = biome.func_225486_c((BlockPos)blockpos$mutable.func_181079_c(p_206967_4_, i1, p_206967_5_)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : p_206967_10_;
                    blockpos$mutable.func_181079_c(k, i1, l);
                }
                i = j;
                if (i1 >= p_206967_14_ - 1) {
                    chunk.func_177436_a((BlockPos)blockpos$mutable, blockstate, false);
                } else if (i1 < p_206967_14_ - 7 - j) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    blockstate1 = p_206967_9_;
                    chunk.func_177436_a((BlockPos)blockpos$mutable, p_206967_13_, false);
                } else {
                    chunk.func_177436_a((BlockPos)blockpos$mutable, blockstate1, false);
                }
            } else if (i > 0) {
                chunk.func_177436_a((BlockPos)blockpos$mutable, blockstate1, false);
                if (--i == 0 && blockstate1.func_203425_a(Blocks.field_150354_m) && j > 1) {
                    i = random.nextInt(4) + Math.max(0, i1 - 63);
                    BlockState blockState = blockstate1 = blockstate1.func_203425_a(Blocks.field_196611_F) ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
                }
            }
            if (chunk.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(Blocks.field_150348_b)) {
                chunk.func_177436_a((BlockPos)blockpos$mutable, STONE, false);
            }
            if (chunk.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(Blocks.field_150355_j)) {
                chunk.func_177436_a((BlockPos)blockpos$mutable, PACKED_ICE, false);
            }
            if (!chunk.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(BlockRegistry.frozenGrass)) continue;
            chunk.func_177436_a(blockpos$mutable.func_177984_a(), SNOW, false);
        }
    }

    protected boolean heightCheck(IChunk world, BlockPos pos, int maxHeight, int width) {
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + maxHeight < 256) {
            for (int i = 1; i <= maxHeight; ++i) {
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < width; ++z) {
                        if (IceikaSurfaceBuilder.hasSpace(world, pos.func_177982_a(x, i, z))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean hasSpace(IChunk world, BlockPos pos) {
        BlockState oldState = world.func_180495_p(pos);
        Block oldBlock = oldState.func_177230_c();
        return oldBlock.isAir(oldState, (IBlockReader)world, pos) || oldBlock.func_203417_a((ITag)BlockTags.field_206952_E) || oldBlock.func_203417_a((ITag)BlockTags.field_226149_I_);
    }
}

