/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.vethea;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TemplatePlacer
extends Feature {
    private final ResourceLocation location;
    private final BlockPos possibleSize;

    public TemplatePlacer(ResourceLocation location) {
        this(location, null);
    }

    public TemplatePlacer(ResourceLocation location, boolean checkCanPlace) {
        this(location, (BlockPos)(checkCanPlace ? BlockPos.field_177992_a : null));
    }

    public TemplatePlacer(ResourceLocation location, BlockPos possibleSize) {
        super(BlockStateFeatureConfig.field_236455_a_);
        this.location = location;
        this.possibleSize = possibleSize;
    }

    private Template getTemplate(World world) {
        TemplateManager manager = world.func_73046_m().func_240792_aT_();
        Template template = manager.func_200219_b(this.location);
        return template;
    }

    public boolean canPlace(IServerWorld world, BlockPos pos) {
        Template template = this.getTemplate((World)world.func_201672_e());
        BlockPos size = template.func_186259_a();
        AtomicBoolean canPlace = new AtomicBoolean(true);
        BlockPos.func_218278_a((BlockPos)pos.func_177982_a(0, 1, 0), (BlockPos)pos.func_177971_a((Vector3i)size)).forEach(x -> {
            if (canPlace.get() && !world.func_180495_p(x).func_196958_f() && !world.func_180495_p(x).func_177230_c().canBeReplacedByLeaves(world.func_180495_p(x), (IWorldReader)world, x)) {
                canPlace.set(false);
            }
        });
        return canPlace.get();
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, IFeatureConfig config) {
        if (this.possibleSize != null && !this.canPlace((IServerWorld)world, blockPos)) {
            BlockPos innerCopy = new BlockPos((Vector3i)blockPos);
            blockPos = null;
            int x = Math.max(1, this.possibleSize.func_177958_n());
            int y = Math.max(1, this.possibleSize.func_177956_o());
            int z = Math.max(1, this.possibleSize.func_177952_p());
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = innerCopy.func_177982_a(random.nextInt(x), random.nextInt(y), random.nextInt(z));
                if (!this.canPlace((IServerWorld)world, pos)) continue;
                blockPos = pos;
                break;
            }
        }
        if (blockPos == null) {
            return false;
        }
        this.getTemplate((World)world.func_201672_e()).func_237152_b_((IServerWorld)world, blockPos, new PlacementSettings(), random);
        return true;
    }
}

