/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.vethea;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.util.WeightedRandom;
import divinerpg.world.DivineChunkGenerator;
import divinerpg.world.arcana.DivineStructureBlockProcessor;
import divinerpg.world.vethea.VetheaLevelGenerators;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;

public class VetheaChunkGenerator
extends DivineChunkGenerator {
    private final List<VetheaLevelGenerators> levels = new ArrayList<VetheaLevelGenerators>();
    private int floorHeight = 48;
    private int roofHeight = 16;
    protected Random rand = new Random();
    public static final Codec<VetheaChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.field_222542_c), (App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(ChunkGenerator::func_235957_b_)).apply((Applicative)instance, instance.stable(VetheaChunkGenerator::new)));

    public VetheaChunkGenerator(BiomeProvider provider, DimensionStructuresSettings settings) {
        super(provider, settings);
        for (int i = 0; i < 4; ++i) {
            VetheaLevelGenerators level = new VetheaLevelGenerators(this.floorHeight * i, this.roofHeight);
            this.levels.add(level);
        }
    }

    @Override
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public void func_230351_a_(WorldGenRegion region, StructureManager structureManager) {
        int x = region.func_201679_a() * 16;
        int z = region.func_201680_b() * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        long worldSeed = region.func_72905_C();
        Random random = region.func_201674_k();
        this.levels.forEach(level -> level.populate(region, random, region.func_201679_a(), region.func_201680_b()));
        this.rand.setSeed(region.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)region.func_201679_a() * k + (long)region.func_201680_b() * l ^ region.func_72905_C());
        Biome biome = region.func_226691_t_(new BlockPos(x, 0, z));
        if (this.rand.nextInt(100) == 0) {
            int y = 20 + this.rand.nextInt(8);
            ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
            locations.add(new ResourceLocation("divinerpg", "vethea/layer1/houses/hunger_house_1"));
            locations.add(new ResourceLocation("divinerpg", "vethea/layer1/houses/hunger_house_2"));
            locations.add(new ResourceLocation("divinerpg", "vethea/layer1/houses/hunger_house_3"));
            Template template = region.func_201672_e().func_184163_y().func_200219_b((ResourceLocation)locations.get(random.nextInt(locations.size())));
            if (template != null) {
                template.func_237152_b_((IServerWorld)region, new BlockPos(x, y + 12, z), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
            }
        }
        this.rand.setSeed((long)region.func_201679_a() * k + (long)region.func_201680_b() * l ^ region.func_72905_C());
        this.customize(region, pos);
        super.func_230351_a_(region, structureManager);
    }

    @Override
    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        BlockState bedrock = Blocks.field_150357_h.func_176223_P();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.func_177436_a((BlockPos)pos.func_181079_c(x, 0, z), bedrock, false);
            }
        }
    }

    private void customize(WorldGenRegion region, BlockPos pos) {
        Template layer3;
        Template layer2;
        Template infusion;
        Random random = region.func_201674_k();
        WeightedRandom<ResourceLocation> allLevels = new WeightedRandom<ResourceLocation>();
        WeightedRandom<ResourceLocation> level1 = new WeightedRandom<ResourceLocation>();
        WeightedRandom<ResourceLocation> level2 = new WeightedRandom<ResourceLocation>();
        WeightedRandom<ResourceLocation> level3 = new WeightedRandom<ResourceLocation>();
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/bow"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree1"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree2"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree3"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree4"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree5"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree6"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/floatingtree7"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/hook"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/lamp1"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/lamp2"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/mushroom"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/pickaxe"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/pointedsquare"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/ring"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/sword"), 4);
        allLevels.addItem(new ResourceLocation("divinerpg", "vethea/all_floors/trident"), 4);
        level1.addItem(new ResourceLocation("divinerpg", "vethea/layer1/tree4"), 4);
        level1.addItem(new ResourceLocation("divinerpg", "vethea/layer1/tree5"), 4);
        level1.addItem(new ResourceLocation("divinerpg", "vethea/layer1/tree6"), 4);
        level2.addItem(new ResourceLocation("divinerpg", "vethea/layer2/tree3"), 4);
        level3.addItem(new ResourceLocation("divinerpg", "vethea/layer3/tree7"), 4);
        level3.addItem(new ResourceLocation("divinerpg", "vethea/layer3/tree8"), 4);
        ArrayList posList = new ArrayList();
        BlockPos bottom = (BlockPos)BlockPos.func_218278_a((BlockPos)new BlockPos(pos.func_177958_n(), 18, pos.func_177952_p()), (BlockPos)new BlockPos(pos.func_177958_n(), 37, pos.func_177952_p())).iterator().next();
        BlockPos second = (BlockPos)BlockPos.func_218278_a((BlockPos)new BlockPos(pos.func_177958_n(), 65, pos.func_177952_p()), (BlockPos)new BlockPos(pos.func_177958_n(), 86, pos.func_177952_p())).iterator().next();
        BlockPos third = (BlockPos)BlockPos.func_218278_a((BlockPos)new BlockPos(pos.func_177958_n(), 113, pos.func_177952_p()), (BlockPos)new BlockPos(pos.func_177958_n(), 134, pos.func_177952_p())).iterator().next();
        BlockPos top = (BlockPos)BlockPos.func_218278_a((BlockPos)new BlockPos(pos.func_177958_n(), 161, pos.func_177952_p()), (BlockPos)new BlockPos(pos.func_177958_n(), region.func_217301_I() - 1, pos.func_177952_p())).iterator().next();
        posList.addAll(ImmutableList.of((Object)bottom, (Object)second, (Object)third, (Object)top));
        Template template = region.func_201672_e().func_184163_y().func_200219_b((ResourceLocation)allLevels.selectRandomItem(random));
        if (template != null) {
            template.func_237152_b_((IServerWorld)region, ((BlockPos)posList.get(random.nextInt(posList.size()))).func_177981_b(random.nextInt(12)), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
        }
        if ((infusion = region.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", "vethea/all_floors/infusionoutpost"))) != null && random.nextInt(500) == 0) {
            infusion.func_237152_b_((IServerWorld)region, (BlockPos)posList.get(random.nextInt(posList.size())), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
        }
        Template cryptTemplate = region.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", "vethea/layer1/crypt"));
        Template cryptTemplate2 = region.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", "vethea/layer1/crypt2"));
        if (cryptTemplate != null && random.nextInt(500) == 0) {
            if (random.nextBoolean()) {
                cryptTemplate.func_237144_a_((IServerWorld)region, bottom.func_177979_c(6), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
            } else {
                cryptTemplate2.func_237144_a_((IServerWorld)region, bottom.func_177979_c(8), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
            }
        }
        if ((layer2 = region.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", random.nextBoolean() ? "vethea/layer2/hive" : "vethea/layer2/temple"))) != null && random.nextInt(500) == 0) {
            layer2.func_237144_a_((IServerWorld)region, second.func_177979_c(1), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
        }
        if ((layer3 = region.func_201672_e().func_184163_y().func_200219_b(new ResourceLocation("divinerpg", random.nextBoolean() ? "vethea/layer3/karos" : "vethea/layer3/quadrotic"))) != null && random.nextInt(500) == 0) {
            layer3.func_237144_a_((IServerWorld)region, third.func_177979_c(1), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
        }
        ArrayList layer4List = new ArrayList();
        layer4List.addAll(ImmutableList.of((Object)new ResourceLocation("divinerpg", "vethea/layer4/evergarden"), (Object)new ResourceLocation("divinerpg", "vethea/layer4/layer4tree1"), (Object)new ResourceLocation("divinerpg", "vethea/layer4/layer4tree2"), (Object)new ResourceLocation("divinerpg", "vethea/layer4/raglokchamber"), (Object)new ResourceLocation("divinerpg", "vethea/layer4/wreckhall")));
        Template layer4 = region.func_201672_e().func_184163_y().func_200219_b((ResourceLocation)layer4List.get(random.nextInt(layer4List.size())));
        if (layer4 != null && random.nextInt(500) == 0) {
            layer4.func_237144_a_((IServerWorld)region, top.func_177979_c(1), new PlacementSettings().func_186222_a(false).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)DivineStructureBlockProcessor.INSTANCE), random);
        }
    }
}

