/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.vethea;

import divinerpg.registries.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;

public class VetheaLevelGenerators {
    private List<Feature> generators = new ArrayList<Feature>();
    private int startHeight;
    private int roofHeight;

    public VetheaLevelGenerators(int startHeight, int roofHeight) {
        this.startHeight = startHeight;
        this.roofHeight = roofHeight;
    }

    public void addWorldGen(Feature generator) {
        this.addWorldGen(generator, false);
    }

    public void addWorldGen(Feature generator, boolean forced) {
        if (forced) {
            this.generators.add(0, generator);
        } else {
            this.generators.add(generator);
        }
    }

    public void populate(WorldGenRegion world, Random random, int chunkX, int chunkZ) {
        this.generateFloors(world.func_212866_a_(chunkX, chunkZ));
    }

    private void generateFloors(IChunk region) {
        int earthLevel = this.startHeight + this.roofHeight;
        int dirtLevel = earthLevel - 1;
        int maxStoneLevel = dirtLevel - 1;
        int maxWidth = 15;
        BlockPos.func_191531_b((int)0, (int)this.startHeight, (int)0, (int)maxWidth, (int)maxStoneLevel, (int)maxWidth).forEach(pos -> {
            if (region.func_180495_p(pos).func_196958_f()) {
                region.func_177436_a((BlockPos)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_239590_i_(), BlockRegistry.dreamStone.func_176223_P(), false);
            }
        });
        BlockPos.func_191531_b((int)0, (int)dirtLevel, (int)0, (int)maxWidth, (int)dirtLevel, (int)maxWidth).forEach(pos -> {
            if (region.func_180495_p(pos).func_196958_f()) {
                region.func_177436_a((BlockPos)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_239590_i_(), BlockRegistry.dreamDirt.func_176223_P(), false);
            }
        });
        BlockPos.func_191531_b((int)0, (int)earthLevel, (int)0, (int)maxWidth, (int)earthLevel, (int)maxWidth).forEach(pos -> {
            if (region.func_180495_p(pos).func_196958_f()) {
                region.func_177436_a((BlockPos)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_239590_i_(), BlockRegistry.dreamGrass.func_176223_P(), false);
            }
        });
    }
}

