/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.vethea;

import com.mojang.serialization.Codec;
import divinerpg.registries.BlockRegistry;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class VetheaPillarFeature
extends Feature<BlockStateFeatureConfig> {
    private int height;
    private int maxRadius = 8;

    public VetheaPillarFeature(Codec<BlockStateFeatureConfig> codec, int height) {
        super(codec);
        this.height = height;
    }

    public boolean place(ISeedReader reader, ChunkGenerator chunkGenerator, Random random, BlockPos pos, BlockStateFeatureConfig config) {
        int additionalWidth = random.nextInt(4) + 3;
        pos = pos.func_177982_a(this.maxRadius, 0, this.maxRadius);
        for (int i = 0; i < this.height; ++i) {
            this.placeBlockCircle(reader, pos.func_177982_a(0, i, 0), Math.abs(this.height / 2 - i) / 5 + additionalWidth);
        }
        return false;
    }

    private void placeBlockCircle(ISeedReader worldIn, BlockPos pos, int radius) {
        if (radius > this.maxRadius) {
            radius = this.maxRadius;
        }
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                BlockPos position = pos.func_177963_a(Math.sin(j) * (double)i, 0.0, Math.cos(j) * (double)i);
                worldIn.func_180501_a(position, BlockRegistry.dreamStone.func_176223_P(), 0);
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
    }
}

