/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import net.minecraft.client.resources.ClientLanguageMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LanguageManager
implements IResourceManagerReloadListener {
    private static final Logger field_147648_b = LogManager.getLogger();
    private static final Language field_239503_b_ = new Language("en_us", "US", "English", false);
    private Map<String, Language> field_135046_d = ImmutableMap.of((Object)"en_us", (Object)field_239503_b_);
    private String field_135048_c;
    private Language field_239504_e_ = field_239503_b_;

    public LanguageManager(String p_i48112_1_) {
        this.field_135048_c = p_i48112_1_;
    }

    private static Map<String, Language> func_239506_a_(Stream<IResourcePack> p_239506_0_) {
        HashMap map = Maps.newHashMap();
        p_239506_0_.forEach(p_239505_1_ -> {
            try {
                LanguageMetadataSection languagemetadatasection = (LanguageMetadataSection)p_239505_1_.func_195760_a(LanguageMetadataSection.field_195818_a);
                if (languagemetadatasection != null) {
                    for (Language language : languagemetadatasection.func_135018_a()) {
                        map.putIfAbsent(language.getCode(), language);
                    }
                }
            }
            catch (IOException | RuntimeException runtimeexception) {
                field_147648_b.warn("Unable to parse language metadata section of resourcepack: {}", (Object)p_239505_1_.func_195762_a(), (Object)runtimeexception);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Override
    public void func_195410_a(IResourceManager p_195410_1_) {
        this.field_135046_d = LanguageManager.func_239506_a_(p_195410_1_.func_230232_b_());
        Language language = this.field_135046_d.getOrDefault("en_us", field_239503_b_);
        this.field_239504_e_ = this.field_135046_d.getOrDefault(this.field_135048_c, language);
        ArrayList list = Lists.newArrayList((Object[])new Language[]{language});
        if (this.field_239504_e_ != language) {
            list.add(this.field_239504_e_);
        }
        ClientLanguageMap clientlanguagemap = ClientLanguageMap.func_239497_a_(p_195410_1_, list);
        I18n.func_239502_a_(clientlanguagemap);
        LanguageMap.func_240594_a_(clientlanguagemap);
    }

    public void func_135045_a(Language p_135045_1_) {
        this.field_135048_c = p_135045_1_.getCode();
        this.field_239504_e_ = p_135045_1_;
    }

    public Language func_135041_c() {
        return this.field_239504_e_;
    }

    public SortedSet<Language> func_135040_d() {
        return Sets.newTreeSet(this.field_135046_d.values());
    }

    public Language func_191960_a(String p_191960_1_) {
        return this.field_135046_d.get(p_191960_1_);
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.LANGUAGES;
    }
}

