/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerEula;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.listener.LoggingChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.fml.server.ServerModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger field_240759_a_ = LogManager.getLogger();

    public static void main(String[] p_main_0_) {
        OptionParser optionparser = new OptionParser();
        OptionSpecBuilder optionspec = optionparser.accepts("nogui");
        OptionSpecBuilder optionspec1 = optionparser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder optionspec2 = optionparser.accepts("demo");
        OptionSpecBuilder optionspec3 = optionparser.accepts("bonusChest");
        OptionSpecBuilder optionspec4 = optionparser.accepts("forceUpgrade");
        OptionSpecBuilder optionspec5 = optionparser.accepts("eraseCache");
        OptionSpecBuilder optionspec6 = optionparser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec optionspec7 = optionparser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec optionspec13 = optionparser.nonOptions();
        optionparser.accepts("allowUpdates").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)Boolean.TRUE, (Object[])new Boolean[0]);
        optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        try {
            DataPackRegistries datapackregistries;
            OptionSet optionset = optionparser.parse(p_main_0_);
            if (optionset.has((OptionSpec)optionspec7)) {
                optionparser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path path1 = Paths.get("eula.txt", new String[0]);
            ServerEula servereula = new ServerEula(path1);
            if (!servereula.func_154346_a()) {
                field_240759_a_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            CrashReport.func_230188_h_();
            Bootstrap.func_151354_b();
            Bootstrap.func_218821_c();
            Util.func_240994_l_();
            if (!optionset.has((OptionSpec)optionspec1)) {
                ServerModLoader.load();
            }
            DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
            Path path = Paths.get("server.properties", new String[0]);
            ServerPropertiesProvider serverpropertiesprovider = new ServerPropertiesProvider((DynamicRegistries)dynamicregistries$impl, path);
            serverpropertiesprovider.func_219035_b();
            if (optionset.has((OptionSpec)optionspec1)) {
                field_240759_a_.info("Initialized '{}' and '{}'", (Object)path.toAbsolutePath(), (Object)path1.toAbsolutePath());
                return;
            }
            File file1 = new File((String)optionset.valueOf((OptionSpec)optionspec9));
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(file1, MinecraftServer.field_152367_a.getName()));
            String s = (String)Optional.ofNullable(optionset.valueOf((OptionSpec)optionspec10)).orElse(serverpropertiesprovider.func_219034_a().field_219021_o);
            if (s == null || s.isEmpty() || new File(file1, s).getAbsolutePath().equals(new File(s).getAbsolutePath())) {
                field_240759_a_.error("Invalid world directory specified, must not be null, empty or the same directory as your universe! " + s);
                return;
            }
            SaveFormat saveformat = SaveFormat.func_237269_a_(file1.toPath());
            SaveFormat.LevelSave saveformat$levelsave = saveformat.func_237274_c_(s);
            MinecraftServer.func_240777_a_(saveformat$levelsave);
            DatapackCodec datapackcodec = saveformat$levelsave.func_237297_e_();
            boolean flag = optionset.has((OptionSpec)optionspec6);
            if (flag) {
                field_240759_a_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackList resourcepacklist = new ResourcePackList(new IPackFinder[]{new ServerPackFinder(), new FolderPackFinder(saveformat$levelsave.func_237285_a_(FolderName.field_237251_g_).toFile(), IPackNameDecorator.field_232627_c_)});
            DatapackCodec datapackcodec1 = MinecraftServer.func_240772_a_(resourcepacklist, datapackcodec == null ? DatapackCodec.field_234880_a_ : datapackcodec, flag);
            CompletableFuture<DataPackRegistries> completablefuture = DataPackRegistries.func_240961_a_(resourcepacklist.func_232623_f_(), Commands.EnvironmentType.DEDICATED, serverpropertiesprovider.func_219034_a().field_225395_K, Util.func_215072_e(), Runnable::run);
            try {
                datapackregistries = completablefuture.get();
            }
            catch (Exception exception) {
                field_240759_a_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                resourcepacklist.close();
                return;
            }
            datapackregistries.func_240971_i_();
            WorldSettingsImport worldsettingsimport = WorldSettingsImport.func_244335_a(NBTDynamicOps.field_210820_a, datapackregistries.func_240970_h_(), dynamicregistries$impl);
            IServerConfiguration iserverconfiguration = saveformat$levelsave.func_237284_a_((DynamicOps<INBT>)worldsettingsimport, datapackcodec1);
            if (iserverconfiguration == null) {
                DimensionGeneratorSettings dimensiongeneratorsettings;
                WorldSettings worldsettings;
                if (optionset.has((OptionSpec)optionspec2)) {
                    worldsettings = MinecraftServer.field_213219_c;
                    dimensiongeneratorsettings = DimensionGeneratorSettings.func_242752_a(dynamicregistries$impl);
                } else {
                    ServerProperties serverproperties = serverpropertiesprovider.func_219034_a();
                    worldsettings = new WorldSettings(serverproperties.field_219021_o, serverproperties.field_219020_n, serverproperties.field_218990_C, serverproperties.field_219019_m, false, new GameRules(), datapackcodec1);
                    dimensiongeneratorsettings = optionset.has((OptionSpec)optionspec3) ? serverproperties.field_241082_U_.func_236230_k_() : serverproperties.field_241082_U_;
                }
                dimensiongeneratorsettings = (DimensionGeneratorSettings)DimensionGeneratorSettings.field_236201_a_.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicRegistries)dynamicregistries$impl), (Object)dimensiongeneratorsettings).flatMap(nbt -> DimensionGeneratorSettings.field_236201_a_.parse((DynamicOps)worldsettingsimport, nbt)).getOrThrow(false, errorMsg -> {});
                iserverconfiguration = new ServerWorldInfo(worldsettings, dimensiongeneratorsettings, Lifecycle.stable());
            }
            if (optionset.has((OptionSpec)optionspec4)) {
                Main.func_240761_a_(saveformat$levelsave, DataFixesManager.func_210901_a(), optionset.has((OptionSpec)optionspec5), () -> true, iserverconfiguration.func_230418_z_().func_236226_g_());
            }
            saveformat$levelsave.func_237287_a_(dynamicregistries$impl, iserverconfiguration);
            IServerConfiguration iserverconfiguration1 = iserverconfiguration;
            final DedicatedServer dedicatedserver = MinecraftServer.func_240784_a_(arg_0 -> Main.lambda$main$3(dynamicregistries$impl, saveformat$levelsave, resourcepacklist, datapackregistries, iserverconfiguration1, serverpropertiesprovider, minecraftsessionservice, gameprofilerepository, playerprofilecache, optionset, (OptionSpec)optionspec8, (OptionSpec)optionspec11, (OptionSpec)optionspec2, (OptionSpec)optionspec12, (OptionSpec)optionspec, (OptionSpec)optionspec13, arg_0));
            Thread thread = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.func_71263_m(true);
                    LogManager.shutdown();
                }
            };
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_240759_a_));
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception1) {
            field_240759_a_.fatal("Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static void func_240761_a_(SaveFormat.LevelSave p_240761_0_, DataFixer p_240761_1_, boolean p_240761_2_, BooleanSupplier p_240761_3_, ImmutableSet<RegistryKey<World>> p_240761_4_) {
        field_240759_a_.info("Forcing world upgrade!");
        WorldOptimizer worldoptimizer = new WorldOptimizer(p_240761_0_, p_240761_1_, p_240761_4_, p_240761_2_);
        ITextComponent itextcomponent = null;
        while (!worldoptimizer.func_212218_b()) {
            int i;
            ITextComponent itextcomponent1 = worldoptimizer.func_212215_m();
            if (itextcomponent != itextcomponent1) {
                itextcomponent = itextcomponent1;
                field_240759_a_.info(worldoptimizer.func_212215_m().getString());
            }
            if ((i = worldoptimizer.func_212211_j()) > 0) {
                int j = worldoptimizer.func_212208_k() + worldoptimizer.func_212209_l();
                field_240759_a_.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.func_76141_d((float)((float)j / (float)i * 100.0f)), (Object)j, (Object)i);
            }
            if (!p_240761_3_.getAsBoolean()) {
                worldoptimizer.func_212217_a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer lambda$main$3(DynamicRegistries.Impl dynamicregistries$impl, SaveFormat.LevelSave saveformat$levelsave, ResourcePackList resourcepacklist, DataPackRegistries datapackregistries, IServerConfiguration iserverconfiguration1, ServerPropertiesProvider serverpropertiesprovider, MinecraftSessionService minecraftsessionservice, GameProfileRepository gameprofilerepository, PlayerProfileCache playerprofilecache, OptionSet optionset, OptionSpec optionspec8, OptionSpec optionspec11, OptionSpec optionspec2, OptionSpec optionspec12, OptionSpec optionspec, OptionSpec optionspec13, Thread p_240762_16_) {
        boolean flag1;
        DedicatedServer dedicatedserver1 = new DedicatedServer(p_240762_16_, dynamicregistries$impl, saveformat$levelsave, resourcepacklist, datapackregistries, iserverconfiguration1, serverpropertiesprovider, DataFixesManager.func_210901_a(), minecraftsessionservice, gameprofilerepository, playerprofilecache, LoggingChunkStatusListener::new);
        dedicatedserver1.func_71224_l((String)optionset.valueOf(optionspec8));
        dedicatedserver1.func_71208_b((Integer)optionset.valueOf(optionspec11));
        dedicatedserver1.func_71204_b(optionset.has(optionspec2));
        dedicatedserver1.func_213208_c((String)optionset.valueOf(optionspec12));
        boolean bl = flag1 = !optionset.has(optionspec) && !optionset.valuesOf(optionspec13).contains("nogui");
        if (flag1 && !GraphicsEnvironment.isHeadless()) {
            dedicatedserver1.func_120011_ar();
        }
        return dedicatedserver1;
    }
}

