/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import org.apache.commons.lang3.tuple.Pair;

public enum BannerPattern implements IExtensibleEnum
{
    BASE("base", "b", false),
    SQUARE_BOTTOM_LEFT("square_bottom_left", "bl"),
    SQUARE_BOTTOM_RIGHT("square_bottom_right", "br"),
    SQUARE_TOP_LEFT("square_top_left", "tl"),
    SQUARE_TOP_RIGHT("square_top_right", "tr"),
    STRIPE_BOTTOM("stripe_bottom", "bs"),
    STRIPE_TOP("stripe_top", "ts"),
    STRIPE_LEFT("stripe_left", "ls"),
    STRIPE_RIGHT("stripe_right", "rs"),
    STRIPE_CENTER("stripe_center", "cs"),
    STRIPE_MIDDLE("stripe_middle", "ms"),
    STRIPE_DOWNRIGHT("stripe_downright", "drs"),
    STRIPE_DOWNLEFT("stripe_downleft", "dls"),
    STRIPE_SMALL("small_stripes", "ss"),
    CROSS("cross", "cr"),
    STRAIGHT_CROSS("straight_cross", "sc"),
    TRIANGLE_BOTTOM("triangle_bottom", "bt"),
    TRIANGLE_TOP("triangle_top", "tt"),
    TRIANGLES_BOTTOM("triangles_bottom", "bts"),
    TRIANGLES_TOP("triangles_top", "tts"),
    DIAGONAL_LEFT("diagonal_left", "ld"),
    DIAGONAL_RIGHT("diagonal_up_right", "rd"),
    DIAGONAL_LEFT_MIRROR("diagonal_up_left", "lud"),
    DIAGONAL_RIGHT_MIRROR("diagonal_right", "rud"),
    CIRCLE_MIDDLE("circle", "mc"),
    RHOMBUS_MIDDLE("rhombus", "mr"),
    HALF_VERTICAL("half_vertical", "vh"),
    HALF_HORIZONTAL("half_horizontal", "hh"),
    HALF_VERTICAL_MIRROR("half_vertical_right", "vhr"),
    HALF_HORIZONTAL_MIRROR("half_horizontal_bottom", "hhb"),
    BORDER("border", "bo"),
    CURLY_BORDER("curly_border", "cbo"),
    GRADIENT("gradient", "gra"),
    GRADIENT_UP("gradient_up", "gru"),
    BRICKS("bricks", "bri"),
    GLOBE("globe", "glb", true),
    CREEPER("creeper", "cre", true),
    SKULL("skull", "sku", true),
    FLOWER("flower", "flo", true),
    MOJANG("mojang", "moj", true),
    PIGLIN("piglin", "pig", true);

    private static final BannerPattern[] field_235647_S_;
    public static final int field_222480_O;
    public static final int field_235646_Q_;
    public static final int field_222481_P;
    private final boolean field_235648_T_;
    private final String field_191014_N;
    private final String field_191015_O;

    private BannerPattern(String p_i47245_3_, String p_i47245_4_) {
        this(p_i47245_3_, p_i47245_4_, false);
    }

    private BannerPattern(String p_i231861_3_, String p_i231861_4_, boolean p_i231861_5_) {
        this.field_191014_N = p_i231861_3_;
        this.field_191015_O = p_i231861_4_;
        this.field_235648_T_ = p_i231861_5_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation func_226957_a_(boolean p_226957_1_) {
        String s = p_226957_1_ ? "banner" : "shield";
        return new ResourceLocation("entity/" + s + "/" + this.func_190997_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_190997_a() {
        return this.field_191014_N;
    }

    public String func_190993_b() {
        return this.field_191015_O;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static BannerPattern func_190994_a(String p_190994_0_) {
        for (BannerPattern bannerpattern : BannerPattern.values()) {
            if (!bannerpattern.field_191015_O.equals(p_190994_0_)) continue;
            return bannerpattern;
        }
        return null;
    }

    public static BannerPattern create(String enumName, String fileNameIn, String hashNameIn) {
        throw new IllegalStateException("Enum not extended");
    }

    public static BannerPattern create(String enumName, String fileNameIn, String hashNameIn, boolean hasPatternItem) {
        throw new IllegalStateException("Enum not extended");
    }

    static {
        field_235647_S_ = BannerPattern.values();
        field_222480_O = field_235647_S_.length;
        field_235646_Q_ = (int)Arrays.stream(field_235647_S_).filter(p_235649_0_ -> p_235649_0_.field_235648_T_).count();
        field_222481_P = field_222480_O - field_235646_Q_ - 1;
    }

    public static class Builder {
        private final List<Pair<BannerPattern, DyeColor>> field_222478_a = Lists.newArrayList();

        public Builder func_222477_a(BannerPattern p_222477_1_, DyeColor p_222477_2_) {
            this.field_222478_a.add((Pair<BannerPattern, DyeColor>)Pair.of((Object)((Object)p_222477_1_), (Object)((Object)p_222477_2_)));
            return this;
        }

        public ListNBT func_222476_a() {
            ListNBT listnbt = new ListNBT();
            for (Pair<BannerPattern, DyeColor> pair : this.field_222478_a) {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74778_a("Pattern", ((BannerPattern)((Object)pair.getLeft())).field_191015_O);
                compoundnbt.func_74768_a("Color", ((DyeColor)((Object)pair.getRight())).func_196059_a());
                listnbt.add((Object)compoundnbt);
            }
            return listnbt;
        }
    }
}

