/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ICharacterPredicate;
import net.minecraft.crash.ReportedException;
import net.minecraft.state.Property;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Bootstrap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final AtomicInteger field_215090_b = new AtomicInteger(1);
    private static final ExecutorService field_240974_d_ = Util.func_240979_a_("Bootstrap");
    private static final ExecutorService field_215091_c = Util.func_240979_a_("Main");
    private static final ExecutorService field_240975_f_ = Util.func_240995_n_();
    public static LongSupplier field_211180_a = System::nanoTime;
    public static final UUID field_240973_b_ = new UUID(0L, 0L);
    private static final Logger field_195650_a = LogManager.getLogger();

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> func_199749_a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String func_200269_a(Property<T> p_200269_0_, Object p_200269_1_) {
        return p_200269_0_.func_177702_a((Comparable)p_200269_1_);
    }

    public static String func_200697_a(String p_200697_0_, @Nullable ResourceLocation p_200697_1_) {
        return p_200697_1_ == null ? p_200697_0_ + ".unregistered_sadface" : p_200697_0_ + '.' + p_200697_1_.func_110624_b() + '.' + p_200697_1_.func_110623_a().replace('/', '.');
    }

    public static long func_211177_b() {
        return Util.func_211178_c() / 1000000L;
    }

    public static long func_211178_c() {
        return field_211180_a.getAsLong();
    }

    public static long func_211179_d() {
        return Instant.now().toEpochMilli();
    }

    private static ExecutorService func_240979_a_(String p_240979_0_) {
        int i = MathHelper.func_76125_a((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)7);
        Object executorservice = i <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(i, p_240981_1_ -> {
            ForkJoinWorkerThread forkjoinworkerthread = new ForkJoinWorkerThread(p_240981_1_){

                @Override
                protected void onTermination(Throwable p_onTermination_1_) {
                    if (p_onTermination_1_ != null) {
                        field_195650_a.warn("{} died", (Object)this.getName(), (Object)p_onTermination_1_);
                    } else {
                        field_195650_a.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(p_onTermination_1_);
                }
            };
            forkjoinworkerthread.setName("Worker-" + p_240979_0_ + "-" + field_215090_b.getAndIncrement());
            return forkjoinworkerthread;
        }, Util::func_240983_a_, true);
        return executorservice;
    }

    public static Executor func_240991_e_() {
        return field_240974_d_;
    }

    public static Executor func_215072_e() {
        return field_215091_c;
    }

    public static Executor func_240992_g_() {
        return field_240975_f_;
    }

    public static void func_240993_h_() {
        Util.func_240985_a_(field_215091_c);
        Util.func_240985_a_(field_240975_f_);
    }

    private static void func_240985_a_(ExecutorService p_240985_0_) {
        boolean flag;
        p_240985_0_.shutdown();
        try {
            flag = p_240985_0_.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedexception) {
            flag = false;
        }
        if (!flag) {
            p_240985_0_.shutdownNow();
        }
    }

    private static ExecutorService func_240995_n_() {
        return Executors.newCachedThreadPool(p_240978_0_ -> {
            Thread thread = new Thread(p_240978_0_);
            thread.setName("IO-Worker-" + field_215090_b.getAndIncrement());
            thread.setUncaughtExceptionHandler(Util::func_240983_a_);
            return thread;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T> CompletableFuture<T> func_215087_a(Throwable p_215087_0_) {
        CompletableFuture completablefuture = new CompletableFuture();
        completablefuture.completeExceptionally(p_215087_0_);
        return completablefuture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_229756_b_(Throwable p_229756_0_) {
        throw p_229756_0_ instanceof RuntimeException ? (RuntimeException)p_229756_0_ : new RuntimeException(p_229756_0_);
    }

    private static void func_240983_a_(Thread p_240983_0_, Throwable p_240983_1_) {
        Util.func_229757_c_(p_240983_1_);
        if (p_240983_1_ instanceof CompletionException) {
            p_240983_1_ = p_240983_1_.getCause();
        }
        if (p_240983_1_ instanceof ReportedException) {
            Bootstrap.func_179870_a(((ReportedException)p_240983_1_).func_71575_a().func_71502_e());
            System.exit(-1);
        }
        field_195650_a.error(String.format("Caught exception in thread %s", p_240983_0_), p_240983_1_);
    }

    @Nullable
    public static Type<?> func_240976_a_(DSL.TypeReference p_240976_0_, String p_240976_1_) {
        return !SharedConstants.field_240856_c_ ? null : Util.func_240990_b_(p_240976_0_, p_240976_1_);
    }

    @Nullable
    private static Type<?> func_240990_b_(DSL.TypeReference p_240990_0_, String p_240990_1_) {
        Type type;
        block2: {
            type = null;
            try {
                type = DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)SharedConstants.func_215069_a().getWorldVersion())).getChoiceType(p_240990_0_, p_240990_1_);
            }
            catch (IllegalArgumentException illegalargumentexception) {
                field_195650_a.debug("No data fixer registered for {}", (Object)p_240990_1_);
                if (!SharedConstants.field_206244_b) break block2;
                throw illegalargumentexception;
            }
        }
        return type;
    }

    public static OS func_110647_a() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (s.contains("win")) {
            return OS.WINDOWS;
        }
        if (s.contains("mac")) {
            return OS.OSX;
        }
        if (s.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (s.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (s.contains("linux")) {
            return OS.LINUX;
        }
        return s.contains("unix") ? OS.LINUX : OS.UNKNOWN;
    }

    public static Stream<String> func_211565_f() {
        RuntimeMXBean runtimemxbean = ManagementFactory.getRuntimeMXBean();
        return runtimemxbean.getInputArguments().stream().filter(p_211566_0_ -> p_211566_0_.startsWith("-X"));
    }

    public static <T> T func_223378_a(List<T> p_223378_0_) {
        return p_223378_0_.get(p_223378_0_.size() - 1);
    }

    public static <T> T func_195647_a(Iterable<T> p_195647_0_, @Nullable T p_195647_1_) {
        Iterator<T> iterator = p_195647_0_.iterator();
        T t = iterator.next();
        if (p_195647_1_ != null) {
            T t1 = t;
            while (t1 != p_195647_1_) {
                if (!iterator.hasNext()) continue;
                t1 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return t;
    }

    public static <T> T func_195648_b(Iterable<T> p_195648_0_, @Nullable T p_195648_1_) {
        Iterator<T> iterator = p_195648_0_.iterator();
        T t = null;
        while (iterator.hasNext()) {
            T t1 = iterator.next();
            if (t1 == p_195648_1_) {
                if (t != null) break;
                t = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : p_195648_1_);
                break;
            }
            t = t1;
        }
        return t;
    }

    public static <T> T func_199748_a(Supplier<T> p_199748_0_) {
        return p_199748_0_.get();
    }

    public static <T> T func_200696_a(T p_200696_0_, Consumer<T> p_200696_1_) {
        p_200696_1_.accept(p_200696_0_);
        return p_200696_0_;
    }

    public static <K> Hash.Strategy<K> func_212443_g() {
        return IdentityStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> func_215079_b(List<? extends CompletableFuture<? extends V>> p_215079_0_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_215079_0_.size());
        CompletableFuture[] completablefuture = new CompletableFuture[p_215079_0_.size()];
        CompletableFuture completablefuture1 = new CompletableFuture();
        p_215079_0_.forEach(p_215083_3_ -> {
            int i = list.size();
            list.add(null);
            completablefuture[i] = p_215083_3_.whenComplete((p_215085_3_, p_215085_4_) -> {
                if (p_215085_4_ != null) {
                    completablefuture1.completeExceptionally((Throwable)p_215085_4_);
                } else {
                    list.set(i, p_215085_3_);
                }
            });
        });
        return CompletableFuture.allOf(completablefuture).applyToEither((CompletionStage)completablefuture1, p_215089_1_ -> list);
    }

    public static <T> Stream<T> func_215081_a(Optional<? extends T> p_215081_0_) {
        return (Stream)DataFixUtils.orElseGet(p_215081_0_.map(Stream::of), Stream::empty);
    }

    public static <T> Optional<T> func_215077_a(Optional<T> p_215077_0_, Consumer<T> p_215077_1_, Runnable p_215077_2_) {
        if (p_215077_0_.isPresent()) {
            p_215077_1_.accept(p_215077_0_.get());
        } else {
            p_215077_2_.run();
        }
        return p_215077_0_;
    }

    public static Runnable func_215075_a(Runnable p_215075_0_, Supplier<String> p_215075_1_) {
        return p_215075_0_;
    }

    public static <T extends Throwable> T func_229757_c_(T p_229757_0_) {
        if (SharedConstants.field_206244_b) {
            field_195650_a.error("Trying to throw a fatal exception, pausing in IDE", p_229757_0_);
            try {
                while (true) {
                    Thread.sleep(1000L);
                    field_195650_a.error("paused");
                }
            }
            catch (InterruptedException interruptedexception) {
                return p_229757_0_;
            }
        }
        return p_229757_0_;
    }

    public static String func_229758_d_(Throwable p_229758_0_) {
        if (p_229758_0_.getCause() != null) {
            return Util.func_229758_d_(p_229758_0_.getCause());
        }
        return p_229758_0_.getMessage() != null ? p_229758_0_.getMessage() : p_229758_0_.toString();
    }

    public static <T> T func_240989_a_(T[] p_240989_0_, Random p_240989_1_) {
        return p_240989_0_[p_240989_1_.nextInt(p_240989_0_.length)];
    }

    public static int func_240988_a_(int[] p_240988_0_, Random p_240988_1_) {
        return p_240988_0_[p_240988_1_.nextInt(p_240988_0_.length)];
    }

    private static BooleanSupplier func_244363_a(final Path p_244363_0_, final Path p_244363_1_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(p_244363_0_, p_244363_1_, new CopyOption[0]);
                    return true;
                }
                catch (IOException ioexception) {
                    field_195650_a.error("Failed to rename", (Throwable)ioexception);
                    return false;
                }
            }

            public String toString() {
                return "rename " + p_244363_0_ + " to " + p_244363_1_;
            }
        };
    }

    private static BooleanSupplier func_244362_a(final Path p_244362_0_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(p_244362_0_);
                    return true;
                }
                catch (IOException ioexception) {
                    field_195650_a.warn("Failed to delete", (Throwable)ioexception);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + p_244362_0_;
            }
        };
    }

    private static BooleanSupplier func_244366_b(final Path p_244366_0_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(p_244366_0_, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + p_244366_0_ + " is deleted";
            }
        };
    }

    private static BooleanSupplier func_244367_c(final Path p_244367_0_) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(p_244367_0_, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + p_244367_0_ + " is present";
            }
        };
    }

    private static boolean func_244365_a(BooleanSupplier ... p_244365_0_) {
        for (BooleanSupplier booleansupplier : p_244365_0_) {
            if (booleansupplier.getAsBoolean()) continue;
            field_195650_a.warn("Failed to execute {}", (Object)booleansupplier);
            return false;
        }
        return true;
    }

    private static boolean func_244359_a(int p_244359_0_, String p_244359_1_, BooleanSupplier ... p_244359_2_) {
        for (int i = 0; i < p_244359_0_; ++i) {
            if (Util.func_244365_a(p_244359_2_)) {
                return true;
            }
            field_195650_a.error("Failed to {}, retrying {}/{}", (Object)p_244359_1_, (Object)i, (Object)p_244359_0_);
        }
        field_195650_a.error("Failed to {}, aborting, progress might be lost", (Object)p_244359_1_);
        return false;
    }

    public static void func_240977_a_(File p_240977_0_, File p_240977_1_, File p_240977_2_) {
        Util.func_244364_a(p_240977_0_.toPath(), p_240977_1_.toPath(), p_240977_2_.toPath());
    }

    public static void func_244364_a(Path p_244364_0_, Path p_244364_1_, Path p_244364_2_) {
        int i = 10;
        if ((!Files.exists(p_244364_0_, new LinkOption[0]) || Util.func_244359_a(10, "create backup " + p_244364_2_, Util.func_244362_a(p_244364_2_), Util.func_244363_a(p_244364_0_, p_244364_2_), Util.func_244367_c(p_244364_2_))) && Util.func_244359_a(10, "remove old " + p_244364_0_, Util.func_244362_a(p_244364_0_), Util.func_244366_b(p_244364_0_)) && !Util.func_244359_a(10, "replace " + p_244364_0_ + " with " + p_244364_1_, Util.func_244363_a(p_244364_1_, p_244364_0_), Util.func_244367_c(p_244364_0_))) {
            Util.func_244359_a(10, "restore " + p_244364_0_ + " from " + p_244364_2_, Util.func_244363_a(p_244364_2_, p_244364_0_), Util.func_244367_c(p_244364_0_));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_240980_a_(String p_240980_0_, int p_240980_1_, int p_240980_2_) {
        int i = p_240980_0_.length();
        if (p_240980_2_ >= 0) {
            for (int j = 0; p_240980_1_ < i && j < p_240980_2_; ++j) {
                if (!Character.isHighSurrogate(p_240980_0_.charAt(p_240980_1_++)) || p_240980_1_ >= i || !Character.isLowSurrogate(p_240980_0_.charAt(p_240980_1_))) continue;
                ++p_240980_1_;
            }
        } else {
            for (int k = p_240980_2_; p_240980_1_ > 0 && k < 0; ++k) {
                if (!Character.isLowSurrogate(p_240980_0_.charAt(--p_240980_1_)) || p_240980_1_ <= 0 || !Character.isHighSurrogate(p_240980_0_.charAt(p_240980_1_ - 1))) continue;
                --p_240980_1_;
            }
        }
        return p_240980_1_;
    }

    public static Consumer<String> func_240982_a_(String p_240982_0_, Consumer<String> p_240982_1_) {
        return p_240986_2_ -> p_240982_1_.accept(p_240982_0_ + p_240986_2_);
    }

    public static DataResult<int[]> func_240987_a_(IntStream p_240987_0_, int p_240987_1_) {
        int[] aint = p_240987_0_.limit(p_240987_1_ + 1).toArray();
        if (aint.length != p_240987_1_) {
            String s = "Input is not a list of " + p_240987_1_ + " ints";
            return aint.length >= p_240987_1_ ? DataResult.error((String)s, (Object)Arrays.copyOf(aint, p_240987_1_)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)aint);
    }

    public static void func_240994_l_() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedexception) {
                    field_195650_a.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_195650_a));
        thread.start();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_240984_a_(Path p_240984_0_, Path p_240984_1_, Path p_240984_2_) throws IOException {
        Path path = p_240984_0_.relativize(p_240984_2_);
        Path path1 = p_240984_1_.resolve(path);
        Files.copy(p_240984_2_, path1, new CopyOption[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String func_244361_a(String p_244361_0_, ICharacterPredicate p_244361_1_) {
        return p_244361_0_.toLowerCase(Locale.ROOT).chars().mapToObj(p_244360_1_ -> p_244361_1_.test((char)p_244360_1_) ? Character.toString((char)p_244360_1_) : "_").collect(Collectors.joining());
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS{

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected String[] func_195643_b(URL p_195643_1_) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", p_195643_1_.toString()};
            }
        }
        ,
        OSX{

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected String[] func_195643_b(URL p_195643_1_) {
                return new String[]{"open", p_195643_1_.toString()};
            }
        }
        ,
        UNKNOWN;


        @OnlyIn(value=Dist.CLIENT)
        public void func_195639_a(URL p_195639_1_) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.func_195643_b(p_195639_1_)));
                for (String s : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    field_195650_a.error(s);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException privilegedactionexception) {
                field_195650_a.error("Couldn't open url '{}'", (Object)p_195639_1_, (Object)privilegedactionexception);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_195642_a(URI p_195642_1_) {
            try {
                this.func_195639_a(p_195642_1_.toURL());
            }
            catch (MalformedURLException malformedurlexception) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)p_195642_1_, (Object)malformedurlexception);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_195641_a(File p_195641_1_) {
            try {
                this.func_195639_a(p_195641_1_.toURI().toURL());
            }
            catch (MalformedURLException malformedurlexception) {
                field_195650_a.error("Couldn't open file '{}'", (Object)p_195641_1_, (Object)malformedurlexception);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        protected String[] func_195643_b(URL p_195643_1_) {
            String s = p_195643_1_.toString();
            if ("file".equals(p_195643_1_.getProtocol())) {
                s = s.replace("file:", "file://");
            }
            return new String[]{"xdg-open", s};
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_195640_a(String p_195640_1_) {
            try {
                this.func_195639_a(new URI(p_195640_1_).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException urisyntaxexception) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)p_195640_1_, (Object)urisyntaxexception);
            }
        }
    }

    static enum IdentityStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object p_hashCode_1_) {
            return System.identityHashCode(p_hashCode_1_);
        }

        public boolean equals(Object p_equals_1_, Object p_equals_2_) {
            return p_equals_1_ == p_equals_2_;
        }
    }
}

