/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.datagen.recipes.AbstractRecipeGenerator;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;

public class TurbineRecipeGenerator
extends AbstractRecipeGenerator {
    public TurbineRecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Extreme Reactors 2 Turbine recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> c) {
        TurbineVariant variant = TurbineVariant.Basic;
        RegistryObject<BlockItem> casing = Content.Items.TURBINE_CASING_BASIC;
        Tags.IOptionalNamedTag core = Tags.Items.STORAGE_BLOCKS_REDSTONE;
        Tags.IOptionalNamedTag metal = Tags.Items.INGOTS_IRON;
        Tags.IOptionalNamedTag alternativeMetal = null;
        this.turbineCasing(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CASING_BASIC, (ITag<Item>)core, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineGlass(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_GLASS_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.GLASS);
        this.turbineController(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CONTROLLER_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.GEMS_DIAMOND);
        this.turbinePowerTap(c, variant, "fe", (Supplier<? extends IItemProvider>)Content.Items.TURBINE_POWERTAP_FE_PASSIVE_BASIC, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_BASIC, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_221858_em), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151137_ax));
        this.turbineFluidPort(c, variant, "forge", (Supplier<? extends IItemProvider>)Content.Items.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151129_at), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151131_as));
        this.turbineBlade(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_ROTORBLADE_BASIC, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineShaft(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_ROTORSHAFT_BASIC, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineBearing(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_ROTORBEARING_BASIC, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineRedstonePort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_REDSTONEPORT_BASIC, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal, (ITag<Item>)Tags.Items.INGOTS_GOLD);
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:turbine", TurbineRecipeGenerator::turbineRecipeName, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CHARGINGPORT_FE_BASIC, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_BASIC, (IItemProvider)Items.field_151114_aO, (IItemProvider)Items.field_151137_ax);
        this.turbineCasingRecycle(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CASING_BASIC, ContentTags.Items.USING_TURBINE_CASING_BASIC, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_GLASS_BASIC);
        variant = TurbineVariant.Reinforced;
        casing = Content.Items.TURBINE_CASING_REINFORCED;
        core = Tags.Items.STORAGE_BLOCKS_IRON;
        metal = TAG_INGOTS_STEEL;
        alternativeMetal = Tags.Items.STORAGE_BLOCKS_IRON;
        this.turbineCasing(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CASING_REINFORCED, (ITag<Item>)core, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineCasingUpgrade(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CASING_REINFORCED, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineGlass(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_GLASS_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.GLASS);
        this.turbineController(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CONTROLLER_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.turbinePowerTap(c, variant, "fe", (Supplier<? extends IItemProvider>)Content.Items.TURBINE_POWERTAP_FE_PASSIVE_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_221858_em), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151137_ax));
        this.turbineFluidPort(c, variant, "forge", (Supplier<? extends IItemProvider>)Content.Items.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED, (Supplier<? extends IItemProvider>)casing, (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151129_at), (Supplier<? extends IItemProvider>)((Supplier<IItemProvider>)() -> Items.field_151131_as));
        this.turbineComputerPort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_COMPUTERPORT_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineBlade(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_ROTORBLADE_REINFORCED, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineShaft(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_ROTORSHAFT_REINFORCED, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineBearing(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_ROTORBEARING_REINFORCED, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal);
        this.turbineRedstonePort(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_REDSTONEPORT_REINFORCED, (Supplier<? extends IItemProvider>)casing, (ITag.INamedTag<Item>)metal, (ITag.INamedTag<Item>)alternativeMetal, (ITag<Item>)Tags.Items.INGOTS_GOLD);
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:turbine", TurbineRecipeGenerator::turbineRecipeName, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CHARGINGPORT_FE_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED, (IItemProvider)Items.field_221695_cJ, (IItemProvider)Items.field_221858_em);
        this.turbineCasingRecycle(c, variant, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_CASING_REINFORCED, ContentTags.Items.USING_TURBINE_CASING_REINFORCED, (Supplier<? extends IItemProvider>)Content.Items.TURBINE_GLASS_REINFORCED);
    }

    private void turbineCasing(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, ITag<Item> core, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200469_a(Character.valueOf('C'), core).func_200469_a(Character.valueOf('G'), ContentTags.Items.INGOTS_CYANITE).func_200472_a("IGI").func_200472_a("GCG").func_200472_a("IGI").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200409_a(ContentTags.Items.INGOTS_CYANITE)));
    }

    private void turbineCasingUpgrade(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing_upgrade"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing_upgrade_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200462_a(Character.valueOf('C'), (IItemProvider)Content.Blocks.TURBINE_CASING_BASIC.get()).func_200469_a(Character.valueOf('G'), ContentTags.Items.INGOTS_CYANITE).func_200472_a("IGI").func_200472_a("GCG").func_200472_a("IGI").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)Content.Blocks.TURBINE_CASING_BASIC.get()))));
    }

    private void turbineCasingRecycle(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> casingResult, ITag.INamedTag<Item> casingSourceTag, Supplier<? extends IItemProvider> glassSourceItem) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)casingResult.get(), (int)1).func_200487_b(glassSourceItem.get()).func_200490_a("bigreactors:turbine").func_200483_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)glassSourceItem.get())).func_200485_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "casing_recycle_glass"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)casingResult.get(), (int)4).func_203221_a(casingSourceTag).func_200490_a("bigreactors:turbine").func_200483_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200409_a(casingSourceTag)).func_200485_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "casing_recycle"));
    }

    private void turbineGlass(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag<Item> glass) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200469_a(Character.valueOf('G'), glass).func_200472_a("GCG").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200467_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "glass"));
    }

    private void turbineController(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag<Item> diamond) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200469_a(Character.valueOf('Y'), ContentTags.Items.BLOCKS_CYANITE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('D'), diamond).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222029_iU).func_200472_a("CXC").func_200472_a("YDY").func_200472_a("CRC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)TurbineRecipeGenerator.func_200409_a(ContentTags.Items.BLOCKS_CYANITE)).func_200467_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "controller"));
    }

    private void turbinePowerTap(Consumer<IFinishedRecipe> c, TurbineVariant variant, String name, Supplier<? extends IItemProvider> passiveResult, Supplier<? extends IItemProvider> activeResult, Supplier<? extends IItemProvider> casing, Supplier<? extends IItemProvider> energyBig, Supplier<? extends IItemProvider> energySmall) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)passiveResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), energyBig.get()).func_200462_a(Character.valueOf('S'), energySmall.get()).func_200472_a("CSC").func_200472_a("SBS").func_200472_a("CSC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)energySmall.get())).func_200467_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "passivetap_" + name));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)activeResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), energyBig.get()).func_200462_a(Character.valueOf('S'), energySmall.get()).func_200472_a("CBC").func_200472_a("BSB").func_200472_a("CBC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)energyBig.get())).func_200467_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "activetap_" + name));
    }

    private void turbineComputerPort(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "computerport"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "computerport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.STORAGE_BLOCKS_GOLD).func_200469_a(Character.valueOf('Z'), (ITag)Tags.Items.GEMS_LAPIS).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200472_a("CZC").func_200472_a("MGM").func_200472_a("CXC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))));
    }

    private void turbineFluidPort(Consumer<IFinishedRecipe> c, TurbineVariant variant, String name, Supplier<? extends IItemProvider> passiveResult, Supplier<? extends IItemProvider> activeResult, Supplier<? extends IItemProvider> casing, Supplier<? extends IItemProvider> lava, Supplier<? extends IItemProvider> water) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)passiveResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), lava.get()).func_200462_a(Character.valueOf('S'), water.get()).func_200472_a("CSC").func_200472_a("SBS").func_200472_a("CSC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)water.get())).func_200467_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "passivefluidport_" + name));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)activeResult.get()).func_200462_a(Character.valueOf('C'), casing.get()).func_200462_a(Character.valueOf('B'), lava.get()).func_200462_a(Character.valueOf('S'), water.get()).func_200472_a("CBC").func_200472_a("BSB").func_200472_a("CBC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)casing.get())).func_200465_a("has_item2", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)lava.get())).func_200467_a(c, TurbineRecipeGenerator.turbineRecipeName(variant, "activefluidport_" + name));
    }

    private void turbineBlade(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "blade"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "blade_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200469_a(Character.valueOf('C'), ContentTags.Items.INGOTS_CYANITE).func_200472_a("ICI").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200409_a(ContentTags.Items.INGOTS_CYANITE)));
    }

    private void turbineShaft(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "shaft"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "shaft_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200469_a(Character.valueOf('C'), ContentTags.Items.INGOTS_CYANITE).func_200472_a(" I ").func_200472_a("ICI").func_200472_a(" I ").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200409_a(ContentTags.Items.INGOTS_CYANITE)));
    }

    private void turbineBearing(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "bearing"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "bearing_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200469_a(Character.valueOf('I'), (ITag)metalTag).func_200462_a(Character.valueOf('R'), (IItemProvider)Blocks.field_150451_bX).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.STORAGE_BLOCKS_IRON).func_200472_a("IRI").func_200472_a("B B").func_200472_a("IRI").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200409_a((ITag)Tags.Items.STORAGE_BLOCKS_IRON)));
    }

    private void turbineRedstonePort(Consumer<IFinishedRecipe> c, TurbineVariant variant, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> casing, ITag.INamedTag<Item> metal, @Nullable ITag.INamedTag<Item> alternativeMetal, ITag<Item> gold) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "redstoneport"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "redstoneport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)casing.get()).func_200469_a(Character.valueOf('M'), (ITag)metalTag).func_200469_a(Character.valueOf('G'), gold).func_200462_a(Character.valueOf('Z'), (IItemProvider)Items.field_222029_iU).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222027_iT).func_200472_a("CZC").func_200472_a("MGM").func_200472_a("CXC").func_200473_b("bigreactors:turbine").func_200465_a("has_item", (ICriterionInstance)TurbineRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)casing.get()))));
    }

    private static ResourceLocation turbineRecipeName(IMultiblockGeneratorVariant variant, String name) {
        return ExtremeReactors.newID("turbine/" + variant.getName() + "/" + name);
    }

    private static ResourceLocation turbineRecipeName(IMultiblockGeneratorVariant variant, String name, ITag.INamedTag<Item> tag) {
        return ExtremeReactors.newID("turbine/" + variant.getName() + "/" + name + "_" + tag.func_230234_a_().func_110623_a().replace('/', '_'));
    }
}

