/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModel;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModelData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ClientFuelRodsLayout
extends FuelRodsLayout {
    private static final float HORIZONTAL_LEVEL_STEP = 4000.0f / (float)ReactorFuelRodModel.HORIZONTAL_MAX_STEPS;
    private static final float VERTICAL_LEVEL_STEP = 4000.0f / (float)ReactorFuelRodModel.VERTICAL_MAX_STEPS;
    private static final IntSet ALL_CHANGED = IntSets.singleton((int)-1);
    private final FuelData[] _rodsFuelData;
    private float _assemblyFuelQuota = 0.0f;
    private float _assemblyWasteQuota = 0.0f;
    private Colour _fuelColor = this._wasteColor = Colour.WHITE;
    private Colour _wasteColor;

    public ClientFuelRodsLayout(Direction direction, int length) {
        super(direction, length);
        if (this.isVertical()) {
            this._rodsFuelData = new FuelData[this.getRodLength()];
            Arrays.setAll(this._rodsFuelData, idx -> new FuelData(Direction.Axis.Y));
        } else {
            this._rodsFuelData = new FuelData[1];
            this._rodsFuelData[0] = new FuelData(this.getAxis());
        }
    }

    public FuelData getFuelData(int fuelRodIndex) {
        if (this.isVertical()) {
            return fuelRodIndex >= 0 && fuelRodIndex < this._rodsFuelData.length ? this._rodsFuelData[fuelRodIndex] : FuelData.EMPTY;
        }
        return this._rodsFuelData[0];
    }

    public Colour getFuelColor() {
        return this._fuelColor;
    }

    public Colour getWasteColor() {
        return this._wasteColor;
    }

    public Colour getModelTint(int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return this.getFuelColor();
            }
            case 1: {
                return this.getWasteColor();
            }
        }
        return Colour.WHITE;
    }

    @Override
    public IntSet updateFuelData(IFuelContainer fuelContainer, int fuelRodsInReactor) {
        super.updateFuelData(fuelContainer, fuelRodsInReactor);
        boolean reactantsChanged = this.updateGfx(fuelContainer);
        this.updateQuotas(fuelContainer, fuelRodsInReactor);
        if (this.isVertical()) {
            return this.updateFuelDataVertically(reactantsChanged);
        }
        return this.updateFuelDataHorizontally(reactantsChanged);
    }

    @Override
    public void updateFuelRodsOcclusion(World world, Iterable<ReactorFuelRodEntity> fuelRods, boolean interiorInvisible) {
        if (interiorInvisible) {
            fuelRods.forEach(r -> r.setOccluded(true));
            return;
        }
        Direction[] directions = this.getRadiateDirections();
        RenderType solid = RenderType.func_228639_c_();
        for (ReactorFuelRodEntity fuelRod : fuelRods) {
            BlockPos rodPosition = fuelRod.getWorldPosition();
            boolean occluded = true;
            for (Direction direction : directions) {
                BlockPos checkPosition = rodPosition.func_177972_a(direction);
                BlockState state = world.func_180495_p(checkPosition);
                if (!state.isAir((IBlockReader)world, checkPosition) && RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)solid)) continue;
                occluded = false;
                break;
            }
            fuelRod.setOccluded(occluded);
        }
    }

    private IntSet updateFuelDataVertically(boolean reactantsChanged) {
        IntArraySet updatedIndices = new IntArraySet(this.getRodLength());
        float rodCapacity = 4000.0f;
        float remainingWaste = this._assemblyWasteQuota;
        float remainingFuel = this._assemblyFuelQuota;
        for (int i = 0; i < this.getRodLength(); ++i) {
            float fuelAmount;
            float wasteAmount;
            if (remainingWaste > 0.0f) {
                wasteAmount = Math.min(remainingWaste, 4000.0f);
                remainingWaste -= wasteAmount;
            } else {
                wasteAmount = 0.0f;
            }
            if (remainingFuel > 0.0f) {
                fuelAmount = Math.min(remainingFuel, 4000.0f - wasteAmount);
                remainingFuel -= fuelAmount;
            } else {
                fuelAmount = 0.0f;
            }
            if (this.getFuelData(i).update(fuelAmount, wasteAmount)) {
                updatedIndices.add(i);
                continue;
            }
            if (!reactantsChanged || !(fuelAmount > 0.0f) && !(wasteAmount > 0.0f)) continue;
            updatedIndices.add(i);
        }
        return updatedIndices;
    }

    private IntSet updateFuelDataHorizontally(boolean reactantsChanged) {
        if (this.getFuelData(0).update(this._assemblyFuelQuota / (float)this.getRodLength(), this._assemblyWasteQuota / (float)this.getRodLength())) {
            return ALL_CHANGED;
        }
        if (reactantsChanged) {
            return ALL_CHANGED;
        }
        return IntSets.EMPTY_SET;
    }

    private boolean isVertical() {
        return Direction.Plane.VERTICAL == this.getOrientation();
    }

    @Override
    public ReactorFuelRodModelData getFuelRodModelData(int rodIndex, boolean rodOccluded) {
        return ReactorFuelRodModelData.from(this.getFuelData(rodIndex), rodOccluded);
    }

    @Override
    public void reset() {
        this._fuelColor = this._wasteColor = Colour.WHITE;
        this._assemblyWasteQuota = 0.0f;
        this._assemblyFuelQuota = 0.0f;
        Arrays.stream(this._rodsFuelData).forEach(FuelData::reset);
    }

    private void setAssemblyFuelQuota(float quota) {
        this._assemblyFuelQuota = ClientFuelRodsLayout.verifyFloat(quota);
    }

    private void setAssemblyWasteQuota(float quota) {
        this._assemblyWasteQuota = ClientFuelRodsLayout.verifyFloat(quota);
    }

    private static float verifyFloat(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? 0.0f : value;
    }

    private static float computeAssemblyReactantQuota(int reactantAmount, int fuelRodsInAssembly, int fuelRodsInReactor) {
        return (float)reactantAmount / (float)fuelRodsInReactor * (float)fuelRodsInAssembly;
    }

    private void updateQuotas(IFuelContainer fuelContainer, int fuelRodsInReactor) {
        fuelRodsInReactor = Math.max(1, fuelRodsInReactor);
        this.setAssemblyFuelQuota(ClientFuelRodsLayout.computeAssemblyReactantQuota(fuelContainer.getFuelAmount(), this.getRodLength(), fuelRodsInReactor));
        this.setAssemblyWasteQuota(ClientFuelRodsLayout.computeAssemblyReactantQuota(fuelContainer.getWasteAmount(), this.getRodLength(), fuelRodsInReactor));
    }

    private boolean updateGfx(IFuelContainer fuelContainer) {
        Colour oldFuelColor = this.getFuelColor();
        Colour oldWasteColor = this.getWasteColor();
        this._fuelColor = fuelContainer.getFuel().map(Reactant::getColour).orElse(Colour.WHITE);
        this._wasteColor = fuelContainer.getWaste().map(Reactant::getColour).orElse(Colour.WHITE);
        return !this.getFuelColor().equals((Object)oldFuelColor) || !this.getWasteColor().equals((Object)oldWasteColor);
    }

    public static class FuelData {
        public static final FuelData EMPTY = new FuelData(Direction.Axis.X);
        private byte _fuelLevel;
        private byte _wasteLevel;
        private final Direction.Axis _orientation;

        FuelData(Direction.Axis orientation) {
            this._orientation = orientation;
            this._wasteLevel = 0;
            this._fuelLevel = 0;
        }

        public byte getFuelLevel() {
            return this._fuelLevel;
        }

        public byte getWasteLevel() {
            return this._wasteLevel;
        }

        public boolean isVertical() {
            return this.getOrientation().func_200128_b();
        }

        public Direction.Axis getOrientation() {
            return this._orientation;
        }

        public void reset() {
            this._wasteLevel = 0;
            this._fuelLevel = 0;
        }

        public String toString() {
            return String.format("Fuel lvl=%d, Waste lvl=%d, Orientation=%s", this._fuelLevel, this._wasteLevel, this._orientation.toString());
        }

        private boolean update(float fuelAmount, float wasteAmount) {
            boolean changed;
            if (this == EMPTY) {
                return false;
            }
            float levelStep = this._orientation.func_200128_b() ? VERTICAL_LEVEL_STEP : HORIZONTAL_LEVEL_STEP;
            byte newFuelLevel = (byte)Math.round(fuelAmount / levelStep);
            byte newWasteLevel = (byte)Math.round(wasteAmount / levelStep);
            boolean bl = changed = this._fuelLevel != newFuelLevel || this._wasteLevel != newWasteLevel;
            if (changed) {
                this._fuelLevel = newFuelLevel;
                this._wasteLevel = newWasteLevel;
            }
            return changed;
        }
    }
}

