/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.ReprocessorPartType;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelData;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage;
import it.zerono.mods.zerocore.lib.energy.NullEnergyHandlers;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class AbstractReprocessorEntity
extends AbstractMultiblockEntity<MultiblockReprocessor>
implements IMultiblockPartTypeProvider<MultiblockReprocessor, ReprocessorPartType> {
    private static final CuboidPartVariantsModelDataCache s_modelDataCaches = new CuboidPartVariantsModelDataCache();

    public AbstractReprocessorEntity(TileEntityType<?> type) {
        super(type);
    }

    protected boolean isReprocessorActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockReprocessor::isMachineActive).orElse(false);
    }

    protected void setReprocessorActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    public IItemHandlerModifiable getItemInventory(IoDirection direction) {
        return (IItemHandlerModifiable)this.evalOnController(r -> r.getItemHandler(direction), ItemHelper.EMPTY_ITEM_HANDLER);
    }

    public IFluidHandler getFluidInventory() {
        return (IFluidHandler)this.evalOnController(MultiblockReprocessor::getFluidHandler, FluidHelper.EMPTY_FLUID_HANDLER);
    }

    public IWideEnergyStorage getEnergyStorage() {
        return (IWideEnergyStorage)this.evalOnController(MultiblockReprocessor::getEnergyStorage, NullEnergyHandlers.STORAGE);
    }

    public ITextComponent getPartDisplayName() {
        return new TranslationTextComponent(this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"));
    }

    public boolean isValidIngredient(ItemStack stack) {
        return (Boolean)this.evalOnController(r -> r.isValidIngredient(stack), false);
    }

    public boolean isValidIngredient(FluidStack stack) {
        return (Boolean)this.evalOnController(r -> r.isValidIngredient(stack), false);
    }

    protected IModelData getUpdatedModelData() {
        return this.getPartType().map(this::getUpdatedModelData).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFrame()) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_part_for_interior", new Object[0]);
            return false;
        }
        if (position.isFace()) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_part_for_face", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockReprocessor createController() {
        return new MultiblockReprocessor(Objects.requireNonNull(this.func_145831_w(), "Trying to create a Controller from a Part without a World"));
    }

    public Class<MultiblockReprocessor> getControllerType() {
        return MultiblockReprocessor.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected IModelData getUpdatedModelData(ReprocessorPartType partType) {
        return s_modelDataCaches.computeIfAbsent(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings(), () -> new CuboidPartVariantsModelData(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings()));
    }
}

