/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.AbstractReprocessorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.Ticker;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.ItemStackRecipeResult;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ReprocessorCollectorEntity
extends AbstractReprocessorEntity {
    private AxisAlignedBB _renderBoundingBox = CodeHelper.EMPTY_AABB;
    private Ticker _tersTicker;
    private ItemStack _recipeSourceItem = this._recipeProductItem = ItemStack.field_190927_a;
    private ItemStack _recipeProductItem;

    public ReprocessorCollectorEntity() {
        super((TileEntityType)Content.TileEntityTypes.REPROCESSOR_COLLECTOR.get());
    }

    public void onRecipeChanged(@Nullable ReprocessorRecipe currentRecipe) {
        if (null != currentRecipe) {
            List ingredients = ((ItemStackRecipeIngredient)currentRecipe.getIngredient1()).getMatchingElements();
            this._recipeSourceItem = ingredients.isEmpty() ? ItemStack.field_190927_a : (ItemStack)ingredients.get(0);
            this._recipeProductItem = ((ItemStackRecipeResult)currentRecipe.getResult()).getResult();
        } else {
            this._recipeSourceItem = this._recipeProductItem = ItemStack.field_190927_a;
        }
        this.callOnLogicalServer(() -> ((ReprocessorCollectorEntity)this).notifyTileEntityUpdate());
    }

    public boolean isRecipeRunning() {
        return this.isReprocessorActive();
    }

    public ItemStack getRecipeSourceItem() {
        return this._recipeSourceItem;
    }

    public ItemStack getRecipeProductItem() {
        return this._recipeProductItem;
    }

    public double getProgress() {
        return (double)this._tersTicker.getTicks() / 40.0;
    }

    public void onClientTick() {
        this.callOnLogicalClient(() -> ((Ticker)this._tersTicker).tick());
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this._recipeSourceItem = ReprocessorCollectorEntity.syncItem(data, "source");
            this._recipeProductItem = ReprocessorCollectorEntity.syncItem(data, "product");
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            ReprocessorCollectorEntity.syncItem(data, "source", this._recipeSourceItem);
            ReprocessorCollectorEntity.syncItem(data, "product", this._recipeProductItem);
        }
        return data;
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (PartPosition.BottomFace == position) {
            return true;
        }
        validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_collector_position", new Object[0]);
        return false;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public void onPostMachineAssembled(MultiblockReprocessor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this._renderBoundingBox = (AxisAlignedBB)this.evalOnController(c -> (AxisAlignedBB)c.mapBoundingBoxCoordinates(AxisAlignedBB::new, CodeHelper.EMPTY_AABB), CodeHelper.EMPTY_AABB);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this._renderBoundingBox;
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this._tersTicker = (Ticker)this.callOnLogicalClient(() -> new Ticker(40), () -> null);
    }

    private static void syncItem(CompoundNBT data, String name, ItemStack stack) {
        if (!stack.func_190926_b()) {
            data.func_74778_a(name, ItemHelper.getItemId((ItemStack)stack).toString());
        }
    }

    @Nullable
    private static ItemStack syncItem(CompoundNBT data, String name) {
        Item item;
        if (data.func_74764_b(name) && null != (item = ItemHelper.getItemFrom((String)data.func_74779_i(name)))) {
            return ItemHelper.stackFrom((IItemProvider)item);
        }
        return ItemStack.field_190927_a;
    }
}

