/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterial;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainerAccess;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineEnvironment;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineMachine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.RpmUpdateTracker;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbineData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbineLogic;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineCasingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineChargingPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbinePowerTapEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorComponentType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AllowedHandlerAction;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.ITickableMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class MultiblockTurbine
extends AbstractGeneratorMultiblockController<MultiblockTurbine, IMultiblockTurbineVariant>
implements ITurbineMachine,
ITurbineEnvironment,
ITurbineWriter,
IDebuggable {
    private static final IFluidContainerAccess FLUID_CONTAINER_ACCESS = new IFluidContainerAccess(){

        @Override
        public AllowedHandlerAction getAllowedActionFor(FluidType fluidType) {
            switch (fluidType) {
                default: {
                    return AllowedHandlerAction.InsertOnly;
                }
                case Liquid: 
            }
            return AllowedHandlerAction.ExtractOnly;
        }

        @Override
        public FluidType getFluidTypeFrom(IoDirection portDirection) {
            switch (portDirection) {
                default: {
                    return FluidType.Gas;
                }
                case Output: 
            }
            return FluidType.Liquid;
        }
    };
    private final TurbineData _data;
    private final TurbineLogic _logic;
    private final IMultiblockTurbineVariant _variant;
    private final FluidContainer _fluidContainer;
    private final RpmUpdateTracker _rpmUpdateTracker;
    private final Set<ITickableMultiblockPart> _attachedTickables;
    private final List<TurbineRotorBearingEntity> _attachedRotorBearings;
    private final Set<TurbineRotorComponentEntity> _attachedRotorComponents;
    private final Set<IPowerPort> _attachedPowerTaps;
    private final Set<TurbineFluidPortEntity> _attachedFluidPorts;
    private final List<TurbineFluidPortEntity> _attachedOutputFluidPorts;
    private final List<TurbineFluidPortEntity> _attachedInputFluidPorts;
    private boolean _active;
    private int _rotorBladesCount;
    private final Set<BlockPos> _validationFoundCoils;

    public MultiblockTurbine(World world, IMultiblockTurbineVariant variant) {
        super(world);
        this._variant = variant;
        this._data = new TurbineData(variant);
        this._fluidContainer = new FluidContainer(FLUID_CONTAINER_ACCESS);
        this._rpmUpdateTracker = new RpmUpdateTracker(100, 5, 10.0f, 100.0f);
        this._active = false;
        this._attachedTickables = Sets.newHashSet();
        this._attachedRotorBearings = Lists.newLinkedList();
        this._attachedPowerTaps = Sets.newHashSet();
        this._attachedRotorComponents = Sets.newHashSet();
        this._rotorBladesCount = 0;
        this._attachedFluidPorts = Sets.newHashSet();
        this._attachedOutputFluidPorts = Lists.newLinkedList();
        this._attachedInputFluidPorts = Lists.newLinkedList();
        this._validationFoundCoils = Sets.newHashSet();
        this._logic = new TurbineLogic(this, this._data, this.getEnergyBuffer());
    }

    public void reset() {
        this.setMachineActive(false);
        this._fluidContainer.reset();
        this._data.reset();
        this.getEnergyBuffer().empty();
        this.resizeFluidContainer();
    }

    public void onFluidPortChanged() {
        this.rebuildFluidPortsSubsets();
    }

    @Override
    public Optional<IFluidHandler> getLiquidHandler() {
        return this.getFluidHandler(IoDirection.Output);
    }

    @Override
    public Optional<IFluidHandler> getGasHandler() {
        return this.getFluidHandler(IoDirection.Input);
    }

    @Override
    public Optional<IFluidHandler> getFluidHandler(IoDirection portDirection) {
        return Optional.of(this._fluidContainer.getWrapper(portDirection));
    }

    @Override
    public boolean isMachineActive() {
        return this._active;
    }

    public void setMachineActive(boolean active) {
        if (this.isMachineActive() == active) {
            return;
        }
        this._active = active;
        if (active) {
            this.forEachConnectedParts(IMultiblockPart::onMachineActivated);
        } else {
            this.forEachConnectedParts(IMultiblockPart::onMachineDeactivated);
        }
        this.callOnLogicalServer(() -> ((MultiblockTurbine)this).markReferenceCoordForUpdate());
    }

    @Override
    public ITurbineEnvironment getEnvironment() {
        return this;
    }

    @Override
    public IFluidContainer getFluidContainer() {
        return this._fluidContainer;
    }

    @Override
    public void performOutputCycle() {
        IProfiler profiler = this.getWorld().func_217381_Z();
        profiler.func_76320_a("Power");
        this.distributeEnergyEqually();
        profiler.func_219895_b("Coolant");
        this.distributeCoolantEqually();
        profiler.func_76319_b();
    }

    @Override
    public void performInputCycle() {
        IProfiler profiler = this.getWorld().func_217381_Z();
        profiler.func_76320_a("Vapor");
        this.acquireVaporEqually();
        profiler.func_76319_b();
    }

    @Override
    public boolean isSimulator() {
        return false;
    }

    @Override
    public Optional<CoilMaterial> getCoilBlock(BlockPos position) {
        return CoilMaterialRegistry.get(this.getWorld().func_180495_p(position));
    }

    @Override
    public RotorComponentType getRotorComponentTypeAt(BlockPos position) {
        World world = this.getWorld();
        BlockState state = world.func_180495_p(position);
        Block block = state.func_177230_c();
        if (state.isAir((IBlockReader)world, position)) {
            return RotorComponentType.Ignore;
        }
        if (block instanceof TurbineRotorComponentBlock) {
            TurbineRotorComponentBlock rotorBlock = (TurbineRotorComponentBlock)block;
            switch ((TurbinePartType)rotorBlock.getPartType()) {
                case RotorBlade: {
                    return RotorComponentType.Blade;
                }
                case RotorShaft: {
                    return RotorComponentType.Shaft;
                }
            }
            return RotorComponentType.Ignore;
        }
        return RotorComponentType.CandidateCoil;
    }

    @Override
    public boolean isAssembledAndActive() {
        return this.isAssembled() && this.isMachineActive();
    }

    @Override
    public int getCoolantAmount() {
        return this._fluidContainer.getLiquidAmount();
    }

    @Override
    public int getVaporAmount() {
        return this._fluidContainer.getGasAmount();
    }

    @Override
    public int getCapacity() {
        return this._fluidContainer.getCapacity();
    }

    @Override
    public int getMaxIntakeRate() {
        return this._data.getMaxIntakeRate();
    }

    @Override
    public int getMaxIntakeRateHardLimit() {
        return this.getVariant().getMaxPermittedFlow();
    }

    @Override
    public double getEnergyGeneratedLastTick() {
        return this._data.getEnergyGeneratedLastTick();
    }

    @Override
    public int getFluidConsumedLastTick() {
        return this._data.getFluidConsumedLastTick();
    }

    @Override
    public float getRotorEfficiencyLastTick() {
        return this._data.getRotorEfficiencyLastTick();
    }

    @Override
    public float getRotorSpeed() {
        int blades = this.getRotorBladesCount();
        int rotorMass = this.getRotorMass();
        if (blades <= 0 || rotorMass <= 0) {
            return 0.0f;
        }
        return this._data.getRotorEnergy() / (float)(blades * rotorMass);
    }

    @Override
    public int getRotorBladesCount() {
        return this._rotorBladesCount;
    }

    @Override
    public float getMaxRotorSpeed() {
        return this.getVariant().getMaxRotorSpeed();
    }

    @Override
    public int getRotorMass() {
        return this._data.getRotorMass();
    }

    @Override
    public VentSetting getVentSetting() {
        return this._data.getVentSetting();
    }

    @Override
    public boolean isInductorEngaged() {
        return this._data.isInductorEngaged();
    }

    @Override
    public void setMaxIntakeRate(int rate) {
        if (this.isAssembled()) {
            this._data.setMaxIntakeRate(rate);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void setMaxIntakeRatePercentage(int percentage) {
        if (this.isAssembled()) {
            this._data.setMaxIntakeRatePercentage(percentage);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void changeMaxIntakeRate(int delta) {
        if (this.isAssembled()) {
            this._data.setMaxIntakeRate(this._data.getMaxIntakeRate() + delta);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void setVentSetting(VentSetting setting) {
        this._data.setVentSetting(setting);
        this.markReferenceCoordDirty();
    }

    @Override
    public void setInductorEngaged(boolean engaged) {
        if (this.isAssembled()) {
            this._data.setInductorEngaged(engaged);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.func_74764_b("active")) {
            this._active = data.func_74767_n("active");
        }
        this.syncChildDataEntityFrom((ISyncableEntity)this._fluidContainer, "fluidcontainer", data, syncReason);
        this.syncChildDataEntityFrom(this._data, "internaldata", data, syncReason);
        if (syncReason.isFullSync()) {
            this._rpmUpdateTracker.setValue(this.getRotorSpeed());
        }
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_74757_a("active", this.isMachineActive());
        this.syncChildDataEntityTo((ISyncableEntity)this._fluidContainer, "fluidcontainer", data, syncReason);
        this.syncChildDataEntityTo(this._data, "internaldata", data, syncReason);
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        if (!this.isAssembled()) {
            return;
        }
        messages.addUnlocalized("Active: %s", new Object[]{this.isMachineActive()});
        this.getEnergyBuffer().getDebugMessages(side, messages);
        messages.add(side, (IDebuggable)this._data, "Internal data:");
        messages.add(side, (IDebuggable)this._fluidContainer, "Fluids Tanks:");
    }

    protected void markReferenceCoordDirty() {
        this._rpmUpdateTracker.reset();
        super.markReferenceCoordDirty();
    }

    @Override
    public IMultiblockTurbineVariant getVariant() {
        return this._variant;
    }

    protected void sendClientUpdates() {
        this.sendUpdates();
    }

    protected boolean updateServer() {
        IProfiler profiler = this.getWorld().func_217381_Z();
        profiler.func_76320_a("Extreme Reactors|Turbine update");
        profiler.func_76320_a("Input");
        this.performInputCycle();
        profiler.func_219895_b("Generate");
        this._logic.update();
        profiler.func_219895_b("Distribute");
        this.performOutputCycle();
        profiler.func_219895_b("Tickables");
        this._attachedTickables.forEach(ITickableMultiblockPart::onMultiblockServerTick);
        profiler.func_219895_b("Updates");
        this.checkAndSendClientUpdates();
        profiler.func_219895_b("RpmTracker");
        if (this._rpmUpdateTracker.shouldUpdate(this.getRotorSpeed())) {
            this.markReferenceCoordDirty();
        }
        profiler.func_76319_b();
        profiler.func_76319_b();
        return this._data.getEnergyGeneratedLastTick() > 0.0 || this._data.getFluidConsumedLastTick() > 0;
    }

    public boolean isPartCompatible(IMultiblockPart<MultiblockTurbine> part) {
        return part instanceof AbstractTurbineEntity && ((AbstractTurbineEntity)part).getMultiblockVariant().filter(variant -> this.getVariant() == variant).isPresent();
    }

    protected void onPartAdded(IMultiblockPart<MultiblockTurbine> newPart) {
        if (newPart instanceof ITickableMultiblockPart) {
            this._attachedTickables.add((ITickableMultiblockPart)newPart);
        }
        if (newPart instanceof TurbineRotorBearingEntity) {
            this._attachedRotorBearings.add((TurbineRotorBearingEntity)newPart);
        } else if (newPart instanceof TurbineRotorComponentEntity) {
            this._attachedRotorComponents.add((TurbineRotorComponentEntity)newPart);
        } else if (newPart instanceof TurbinePowerTapEntity || newPart instanceof TurbineChargingPortEntity) {
            this._attachedPowerTaps.add((IPowerPort)newPart);
        } else if (newPart instanceof TurbineFluidPortEntity) {
            this._attachedFluidPorts.add((TurbineFluidPortEntity)newPart);
        }
    }

    protected void onPartRemoved(IMultiblockPart<MultiblockTurbine> oldPart) {
        if (oldPart instanceof ITickableMultiblockPart) {
            this._attachedTickables.remove(oldPart);
        }
        if (oldPart instanceof TurbineRotorBearingEntity) {
            this._attachedRotorBearings.remove(oldPart);
        } else if (oldPart instanceof TurbineRotorComponentEntity) {
            this._attachedRotorComponents.remove(oldPart);
        } else if (oldPart instanceof TurbinePowerTapEntity || oldPart instanceof TurbineChargingPortEntity) {
            this._attachedPowerTaps.remove(oldPart);
        } else if (oldPart instanceof TurbineFluidPortEntity) {
            this._attachedFluidPorts.remove(oldPart);
        }
    }

    protected void onMachineAssembled() {
        if (this._attachedPowerTaps.isEmpty()) {
            this.setOutputEnergySystem(INTERNAL_ENERGY_SYSTEM);
        } else {
            CodeHelper.optionalIfPresentOrThrow(this._attachedPowerTaps.stream().map(IPowerPort::getPowerPortHandler).map(IPowerPortHandler::getEnergySystem).findFirst(), this::setOutputEnergySystem);
        }
        this._rotorBladesCount = (int)this._attachedRotorComponents.stream().filter(c -> c.isTypeOfPart(TurbinePartType.RotorBlade)).count();
        this.setInteriorInvisible(!this.isAnyPartConnected(part -> part instanceof TurbineGlassEntity));
        this.rebuildFluidPortsSubsets();
        this.getEnergyBuffer().setCapacity(WideAmount.from((long)((long)this.getVariant().getPartEnergyCapacity() * (long)this.getPartsCount())));
        this.getEnergyBuffer().setMaxExtract(this.getVariant().getMaxEnergyExtractionRate());
        this.resizeFluidContainer();
        this.updateRotorAndCoilsParameters();
        this.callOnLogicalSide(() -> ((MultiblockTurbine)this).markReferenceCoordForUpdate(), () -> this.markMultiblockForRenderUpdate());
    }

    protected void onMachineDisassembled() {
        this.setMachineActive(false);
        this._active = false;
        this._data.onTurbineDisassembled();
        this._rpmUpdateTracker.setValue(0.0f);
        this.markMultiblockForRenderUpdate();
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this._attachedRotorBearings.size() != 1) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_rotor_count", new Object[0]);
            return false;
        }
        if (!this.isAnyPartConnected(part -> part instanceof TurbineControllerEntity)) {
            validatorCallback.setLastError("multiblock.validation.turbine.too_few_controllers", new Object[0]);
            return false;
        }
        if (!super.isMachineWhole(validatorCallback)) {
            return false;
        }
        if (!this.validateRotor(this._attachedRotorBearings.get(0), validatorCallback)) {
            return false;
        }
        return this.validateEnergySystems(validatorCallback);
    }

    protected boolean isBlockGoodForFrame(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForTop(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForBottom(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForSides(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(position);
        if (state.isAir((IBlockReader)world, position)) {
            return true;
        }
        if (CoilMaterialRegistry.get(state).isPresent()) {
            this._validationFoundCoils.add(position);
            return true;
        }
        validatorCallback.setLastError(position, "multiblock.validation.turbine.invalid_block_for_interior", new Object[0]);
        return false;
    }

    protected void onAssimilate(IMultiblockController<MultiblockTurbine> assimilated) {
        if (!(assimilated instanceof MultiblockTurbine)) {
            Log.LOGGER.warn(Log.TURBINE, "[{}] Turbine @ {} is attempting to assimilate a non-Turbine machine! That machine's data will be lost!", (Object)CodeHelper.getWorldSideName((World)this.getWorld()), (Object)this.getReferenceCoord());
            return;
        }
        this._data.onAssimilate(((MultiblockTurbine)assimilated)._data);
    }

    protected void onAssimilated(IMultiblockController<MultiblockTurbine> assimilator) {
        this._attachedTickables.clear();
        this._attachedRotorBearings.clear();
        this._rotorBladesCount = 0;
        this._attachedRotorComponents.clear();
        this._attachedPowerTaps.clear();
        this._attachedFluidPorts.clear();
        this._attachedOutputFluidPorts.clear();
        this._attachedInputFluidPorts.clear();
    }

    private boolean validateRotor(TurbineRotorBearingEntity bearing, IMultiblockValidator validatorCallback) {
        this._validationFoundCoils.clear();
        return (Boolean)this.mapBoundingBoxCoordinates((min, max) -> this.validateRotor(bearing, validatorCallback, bearing.getRotorDirection(), (BlockPos)min, (BlockPos)max), false);
    }

    private boolean validateRotor(TurbineRotorBearingEntity bearing, IMultiblockValidator validatorCallback, Direction rotorDirection, BlockPos turbineMin, BlockPos turbineMax) {
        BlockPos endRotorCoord;
        BlockPos rotorCoord = bearing.getWorldPosition();
        switch (rotorDirection.func_176740_k()) {
            case X: {
                endRotorCoord = rotorCoord.func_177967_a(rotorDirection, Math.abs(turbineMax.func_177958_n() - turbineMin.func_177958_n()) - 1);
                break;
            }
            default: {
                endRotorCoord = rotorCoord.func_177967_a(rotorDirection, Math.abs(turbineMax.func_177956_o() - turbineMin.func_177956_o()) - 1);
                break;
            }
            case Z: {
                endRotorCoord = rotorCoord.func_177967_a(rotorDirection, Math.abs(turbineMax.func_177952_p() - turbineMin.func_177952_p()) - 1);
            }
        }
        Set shaftsPositions = this._attachedRotorComponents.stream().filter(TurbineRotorComponentEntity::isShaft).map(AbstractMultiblockPart::getWorldPosition).collect(Collectors.toSet());
        Set bladesPositions = this._attachedRotorComponents.stream().filter(TurbineRotorComponentEntity::isBlade).map(AbstractMultiblockPart::getWorldPosition).collect(Collectors.toSet());
        Direction.Axis rotatedAxis = rotorDirection.func_176740_k();
        boolean encounteredCoils = false;
        while (!shaftsPositions.isEmpty() && !rotorCoord.equals((Object)endRotorCoord)) {
            if (!shaftsPositions.remove(rotorCoord = rotorCoord.func_177972_a(rotorDirection))) {
                validatorCallback.setLastError(rotorCoord, "multiblock.validation.turbine.block_must_be_rotor", new Object[0]);
                return false;
            }
            boolean encounteredBlades = false;
            for (Direction bladeDirection : CodeHelper.perpendicularDirections((Direction)rotorDirection)) {
                boolean bladeFound = false;
                BlockPos checkCoord = rotorCoord.func_177972_a(bladeDirection);
                while (bladesPositions.remove(checkCoord)) {
                    if (encounteredCoils) {
                        validatorCallback.setLastError(checkCoord, "multiblock.validation.turbine.blades_too_far", new Object[0]);
                        return false;
                    }
                    encounteredBlades = true;
                    bladeFound = true;
                    checkCoord = checkCoord.func_177972_a(bladeDirection);
                }
                if (bladeFound || !this._validationFoundCoils.remove(checkCoord)) continue;
                encounteredCoils = true;
                if (encounteredBlades) {
                    validatorCallback.setLastError(checkCoord, "multiblock.validation.turbine.metal_too_near", new Object[0]);
                    return false;
                }
                Direction rotatedDir = CodeHelper.directionRotateAround((Direction)bladeDirection, (Direction.Axis)rotatedAxis);
                BlockPos coilCheck = checkCoord.func_177972_a(rotatedDir);
                this._validationFoundCoils.remove(coilCheck);
                rotatedDir = CodeHelper.directionRotateAround((Direction)CodeHelper.directionRotateAround((Direction)rotatedDir, (Direction.Axis)rotatedAxis), (Direction.Axis)rotatedAxis);
                coilCheck = checkCoord.func_177972_a(rotatedDir);
                this._validationFoundCoils.remove(coilCheck);
            }
        }
        if (!rotorCoord.equals((Object)endRotorCoord)) {
            validatorCallback.setLastError("multiblock.validation.turbine.shaft_too_short", new Object[0]);
            return false;
        }
        if (!shaftsPositions.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.found_loose_rotor_blocks", new Object[]{shaftsPositions.size()});
            return false;
        }
        if (!bladesPositions.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.found_loose_rotor_blades", new Object[]{bladesPositions.size()});
            return false;
        }
        if (!this._validationFoundCoils.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_metals_shape", new Object[]{this._validationFoundCoils.size()});
            return false;
        }
        if (WorldHelper.getTile((World)this.getWorld(), (BlockPos)rotorCoord.func_177972_a(rotorDirection)).map(te -> te instanceof TurbineCasingEntity).orElse(false).booleanValue()) {
            return true;
        }
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_rotor_end", new Object[0]);
        return false;
    }

    private boolean validateEnergySystems(IMultiblockValidator validatorCallback) {
        if (!this._attachedPowerTaps.isEmpty() && 1L != this._attachedPowerTaps.stream().map(IPowerPort::getPowerPortHandler).map(IPowerPortHandler::getEnergySystem).distinct().limit(2L).count()) {
            validatorCallback.setLastError("multiblock.validation.reactor.mixed_power_systems", new Object[0]);
            return false;
        }
        return true;
    }

    private void distributeEnergyEqually() {
        WideEnergyBuffer energyBuffer = this.getEnergyBuffer();
        WideAmount amountDistributed = MultiblockTurbine.distributeEnergyEqually(energyBuffer.getEnergyStored(), this._attachedPowerTaps);
        if (amountDistributed.greaterThan(WideAmount.ZERO)) {
            energyBuffer.shrink(amountDistributed);
        }
    }

    private void distributeCoolantEqually() {
        int amountDistributed = MultiblockTurbine.distributeFluidEqually((FluidStack)this._fluidContainer.getStackCopy(FluidType.Liquid), this._attachedOutputFluidPorts);
        if (amountDistributed > 0) {
            this._fluidContainer.extract(FluidType.Liquid, amountDistributed, OperationMode.Execute);
        }
    }

    private void acquireVaporEqually() {
        MultiblockTurbine.acquireFluidEqually(this._fluidContainer.getWrapper(IoDirection.Input), this._fluidContainer.getFreeSpace(FluidType.Gas), this._attachedInputFluidPorts);
    }

    private static boolean invalidBlockForExterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        validatorCallback.setLastError(position, "multiblock.validation.turbine.invalid_block_for_exterior", new Object[]{ModBlock.getNameForTranslation((Block)world.func_180495_p(position).func_177230_c())});
        return false;
    }

    private void updateRotorAndCoilsParameters() {
        this.forBoundingBoxCoordinates((min, max) -> this._data.update(this.getEnvironment(), (BlockPos)min, (BlockPos)max, this.getVariant()), min -> min.func_177982_a(1, 1, 1), max -> max.func_177982_a(-1, -1, -1));
    }

    private int calculateTurbineVolume() {
        return (Integer)this.mapBoundingBoxCoordinates((min, max) -> CodeHelper.mathVolume((BlockPos)min.func_177982_a(1, 1, 1), (BlockPos)max.func_177982_a(-1, -1, -1)), 0);
    }

    private void resizeFluidContainer() {
        int outerVolume = (Integer)this.mapBoundingBoxCoordinates(CodeHelper::mathVolume, 0) - this.calculateTurbineVolume();
        this._fluidContainer.setCapacity(MathHelper.func_76125_a((int)(outerVolume * this.getVariant().getPartFluidCapacity()), (int)0, (int)this.getVariant().getMaxFluidCapacity()));
    }

    private void rebuildFluidPortsSubsets() {
        this._attachedInputFluidPorts.clear();
        this._attachedOutputFluidPorts.clear();
        for (TurbineFluidPortEntity port : this._attachedFluidPorts) {
            if (!port.getFluidPortHandler().isActive()) continue;
            if (port.getIoDirection().isInput()) {
                this._attachedInputFluidPorts.add(port);
                continue;
            }
            this._attachedOutputFluidPorts.add(port);
        }
    }
}

