/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.List;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IIOFilterUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;

public class InventoryIOHandler {
    private final IItemHandlerSimpleInserter filteredItemHandler;

    public InventoryIOHandler(IBackpackWrapper backpackWrapper) {
        ArrayList<FilterLogic> inputFilters = new ArrayList<FilterLogic>();
        ArrayList<FilterLogic> outputFilters = new ArrayList<FilterLogic>();
        this.addFilters(backpackWrapper, inputFilters, outputFilters);
        IItemHandlerSimpleInserter modifiedInventory = backpackWrapper.getInventoryForUpgradeProcessing();
        this.filteredItemHandler = inputFilters.isEmpty() && outputFilters.isEmpty() ? modifiedInventory : new FilteredItemHandler.Modifiable(modifiedInventory, (List<FilterLogic>)inputFilters, (List<FilterLogic>)outputFilters);
    }

    public IItemHandlerSimpleInserter getFilteredItemHandler() {
        return this.filteredItemHandler;
    }

    private void addFilters(IBackpackWrapper backpackWrapper, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
        List<IIOFilterUpgrade> filterWrappers = backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IIOFilterUpgrade.class);
        for (IIOFilterUpgrade wrapper : filterWrappers) {
            wrapper.getInputFilter().ifPresent(inputFilters::add);
            wrapper.getOutputFilter().ifPresent(outputFilters::add);
        }
    }
}

