/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.AccessLogRecord;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackPlayerArgumentType;

public class ListCommand {
    private ListCommand() {
    }

    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").executes(context -> ListCommand.printBackpackList(new ArrayList<AccessLogRecord>(BackpackAccessLogger.getAllBackpackLogs()), (CommandSource)context.getSource()))).then(Commands.func_197056_a((String)"playerName", (ArgumentType)BackpackPlayerArgumentType.playerName()).executes(context -> ListCommand.printBackpackList(new ArrayList<AccessLogRecord>(BackpackAccessLogger.getBackpackLogsForPlayer((String)context.getArgument("playerName", String.class))), (CommandSource)context.getSource())));
    }

    private static int printBackpackList(List<AccessLogRecord> allLogs, CommandSource source) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        allLogs.sort(Comparator.comparing(AccessLogRecord::getAccessTime).reversed());
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.sophisticatedbackpacks.list.header"), false);
        allLogs.forEach(alr -> {
            StringTextComponent message = new StringTextComponent("");
            message.func_230529_a_((ITextComponent)new StringTextComponent(alr.getBackpackName()).func_240700_a_(s -> s.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sophisticatedbackpacks give @p " + alr.getBackpackUuid())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.sophisticatedbackpacks.backpack_uuid.tooltip", new Object[]{alr.getBackpackUuid()})))));
            message.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            TranslationTextComponent clothColor = new TranslationTextComponent("commands.sophisticatedbackpacks.list.cloth_color");
            clothColor.func_240703_c_(clothColor.func_150256_b().func_240718_a_(Color.func_240743_a_((int)alr.getClothColor())));
            message.func_230529_a_((ITextComponent)clothColor);
            message.func_230529_a_((ITextComponent)new StringTextComponent(" "));
            TranslationTextComponent trimColor = new TranslationTextComponent("commands.sophisticatedbackpacks.list.trim_color");
            trimColor.func_240703_c_(trimColor.func_150256_b().func_240718_a_(Color.func_240743_a_((int)alr.getTrimColor())));
            message.func_230529_a_((ITextComponent)trimColor);
            message.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            message.func_230529_a_((ITextComponent)new StringTextComponent(alr.getPlayerName()));
            message.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            message.func_230529_a_((ITextComponent)new StringTextComponent(dateFormat.format(new Date(alr.getAccessTime()))));
            source.func_197030_a((ITextComponent)message, false);
        });
        return 0;
    }
}

