/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;
import net.p3pp3rf1y.sophisticatedbackpacks.common.EntityBackpackAdditionHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModParticles;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.RegistryLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.ServerBackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;

public class CommonProxy {
    private final RegistryLoader registryLoader = new RegistryLoader();
    private final PlayerInventoryProvider playerInventoryProvider = new PlayerInventoryProvider();
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 40;
    private long nextBackpackCountCheck = 0L;

    public void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.registerHandlers(modBus);
        ModBlocks.registerHandlers(modBus);
        ModFluids.registerHandlers(modBus);
        ModParticles.registerParticles(modBus);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onItemPickup);
        eventBus.addListener(this::onLivingSpecialSpawn);
        eventBus.addListener(this::onLivingDrops);
        eventBus.addListener(this::onCauldronInteract);
        eventBus.addListener(this::onEntityMobGriefing);
        eventBus.addListener(this::onEntityLeaveWorld);
        eventBus.addListener(ServerBackpackSoundHandler::tick);
        eventBus.addListener(this::onBlockClick);
        eventBus.addListener(this::onAttackEntity);
        eventBus.addListener(EntityBackpackAdditionHandler::onLivingUpdate);
        eventBus.addListener(this::onAddReloadListener);
        eventBus.addListener(this::onPlayerLoggedIn);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onWorldTick);
    }

    private void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K || event.phase != TickEvent.Phase.END || Boolean.FALSE.equals(Config.COMMON.nerfsConfig.tooManyBackpacksSlowness.get()) || this.nextBackpackCountCheck > event.world.func_82737_E()) {
            return;
        }
        this.nextBackpackCountCheck = event.world.func_82737_E() + 40L;
        event.world.func_217369_A().forEach(player -> {
            AtomicInteger numberOfBackpacks = new AtomicInteger(0);
            SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().runOnBackpacks((PlayerEntity)player, (backpack, handlerName, identifier, slot) -> {
                numberOfBackpacks.incrementAndGet();
                return false;
            });
            int maxNumberOfBackpacks = (Integer)Config.COMMON.nerfsConfig.maxNumberOfBackpacks.get();
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)Config.COMMON.nerfsConfig.slownessLevelsPerAdditionalBackpack.get()));
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public PlayerInventoryProvider getPlayerInventoryProvider() {
        return this.playerInventoryProvider;
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PacketHandler.sendToClient((ServerPlayerEntity)event.getPlayer(), new SyncPlayerSettingsMessage(BackpackSettingsManager.getPlayerBackpackSettingsTag(event.getPlayer())));
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHandler.sendToClient((ServerPlayerEntity)event.getPlayer(), new SyncPlayerSettingsMessage(BackpackSettingsManager.getPlayerBackpackSettingsTag(event.getPlayer())));
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this.registryLoader);
    }

    private void onCauldronInteract(PlayerInteractEvent.RightClickBlock event) {
        Hand hand;
        PlayerEntity player = event.getPlayer();
        ItemStack backpack = player.func_184586_b(hand = event.getHand());
        if (!(backpack.func_77973_b() instanceof BackpackItem)) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != Blocks.field_150383_bp) {
            return;
        }
        int level = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
        LazyOptional backpackWrapperCapability = backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance());
        if (level == 0 || backpackWrapperCapability.map(this::hasDefaultColor).orElse(true).booleanValue()) {
            return;
        }
        if (!world.field_72995_K) {
            backpackWrapperCapability.ifPresent(w -> {
                w.setColors(13394234, 6434330);
                ((CauldronBlock)block).func_176590_a(world, pos, state, level - 1);
            });
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
    }

    private boolean hasDefaultColor(IBackpackWrapper wrapper) {
        return wrapper.getBorderColor() == 6434330 && wrapper.getClothColor() == 13394234;
    }

    private void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        this.playerInventoryProvider.runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IBlockClickResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IBlockClickResponseUpgrade.class)) {
                if (!upgrade.onBlockClick(player, pos)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onAttackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.playerInventoryProvider.runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            for (IAttackEntityResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IAttackEntityResponseUpgrade.class)) {
                if (!upgrade.onAttackEntity(player)) continue;
                return true;
            }
            return false;
        }).orElse(false));
    }

    private void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        MonsterEntity monster;
        Entity entity = event.getEntity();
        if (entity instanceof MonsterEntity && (monster = (MonsterEntity)entity).func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
            EntityBackpackAdditionHandler.addBackpack(monster);
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        EntityBackpackAdditionHandler.handleBackpackDrop(event);
    }

    private void onEntityMobGriefing(EntityMobGriefingEvent event) {
        if (event.getEntity() instanceof CreeperEntity) {
            EntityBackpackAdditionHandler.removeBeneficialEffects((CreeperEntity)event.getEntity());
        }
    }

    private void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        if (!(event.getEntity() instanceof MonsterEntity)) {
            return;
        }
        EntityBackpackAdditionHandler.removeBackpackUuid((MonsterEntity)event.getEntity());
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        ItemEntity itemEntity = event.getItem();
        if (itemEntity.func_92059_d().func_190926_b()) {
            return;
        }
        AtomicReference<ItemStack> remainingStackSimulated = new AtomicReference<ItemStack>(itemEntity.func_92059_d().func_77946_l());
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        this.playerInventoryProvider.runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            remainingStackSimulated.set(InventoryHelper.runPickupOnBackpack(world, (ItemStack)remainingStackSimulated.get(), wrapper, true));
            return ((ItemStack)remainingStackSimulated.get()).func_190926_b();
        }).orElse(false));
        if (remainingStackSimulated.get().func_190926_b()) {
            ItemStack remainingStack = itemEntity.func_92059_d().func_77946_l();
            this.playerInventoryProvider.runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> InventoryHelper.runPickupOnBackpack(world, player, remainingStack, wrapper, false).func_190926_b()).orElse(false));
            if (!itemEntity.func_174814_R()) {
                Random rand = itemEntity.field_70170_p.field_73012_v;
                itemEntity.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne(rand) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.func_92058_a(ItemStack.field_190927_a);
            event.setCanceled(true);
        }
    }
}

