/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade;

public class BlockToolSwapMessage {
    private final BlockPos pos;

    public BlockToolSwapMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(BlockToolSwapMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeLong(msg.pos.func_218275_a());
    }

    public static BlockToolSwapMessage decode(PacketBuffer packetBuffer) {
        return new BlockToolSwapMessage(BlockPos.func_218283_e((long)packetBuffer.readLong()));
    }

    static void onMessage(BlockToolSwapMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BlockToolSwapMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(BlockToolSwapMessage msg, @Nullable ServerPlayerEntity sender) {
        if (sender == null) {
            return;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        AtomicBoolean anyUpgradeCanInteract = new AtomicBoolean(false);
        SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().runOnBackpacks((PlayerEntity)sender, (backpack, inventoryName, identifier, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(backpackWrapper -> {
            backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IBlockToolSwapUpgrade.class).forEach(upgrade -> {
                if (!upgrade.canProcessBlockInteract() || result.get()) {
                    return;
                }
                anyUpgradeCanInteract.set(true);
                result.set(upgrade.onBlockInteract(sender.field_70170_p, msg.pos, sender.field_70170_p.func_180495_p(msg.pos), (PlayerEntity)sender));
            });
            return result.get();
        }).orElse(false));
        if (!anyUpgradeCanInteract.get()) {
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("gui.sophisticatedbackpacks.status.no_tool_swap_upgrade_present"), true);
            return;
        }
        if (!result.get()) {
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("gui.sophisticatedbackpacks.status.no_tool_found_for_block"), true);
        }
    }
}

