/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.BlockContext;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.CacheableStackPredicate;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.IMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ItemMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ItemTagMatcher;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ModMatcher;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.TypedMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class Matchers {
    private static final List<ItemMatcherFactory> ITEM_MATCHER_FACTORIES = new ArrayList<ItemMatcherFactory>();
    private static final List<IMatcherFactory<BlockContext>> BLOCK_MATCHER_FACTORIES = new ArrayList<IMatcherFactory<BlockContext>>();
    private static final List<IMatcherFactory<Entity>> ENTITY_MATCHER_FACTORIES = new ArrayList<IMatcherFactory<Entity>>();

    private Matchers() {
    }

    static void addItemMatcherFactory(ItemMatcherFactory matcherFactory) {
        ITEM_MATCHER_FACTORIES.add(matcherFactory);
    }

    public static Optional<CacheableStackPredicate> getItemMatcher(JsonElement jsonElement) {
        for (ItemMatcherFactory itemMatcherFactory : ITEM_MATCHER_FACTORIES) {
            if (!itemMatcherFactory.appliesTo(jsonElement)) continue;
            return itemMatcherFactory.getPredicate(jsonElement);
        }
        return Optional.empty();
    }

    public static List<IMatcherFactory<BlockContext>> getBlockMatcherFactories() {
        return BLOCK_MATCHER_FACTORIES;
    }

    public static List<IMatcherFactory<Entity>> getEntityMatcherFactories() {
        return ENTITY_MATCHER_FACTORIES;
    }

    static {
        Matchers.addItemMatcherFactory(new ItemMatcherFactory("tag"){

            @Override
            protected Optional<CacheableStackPredicate> getPredicateFromObject(JsonObject jsonObject) {
                String tagName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag");
                ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(tagName));
                return tag == null ? Optional.empty() : Optional.of(new ItemTagMatcher((ITag<Item>)tag));
            }
        });
        Matchers.addItemMatcherFactory(new ItemMatcherFactory("emptynbt"){

            @Override
            protected Optional<CacheableStackPredicate> getPredicateFromObject(JsonObject jsonObject) {
                ResourceLocation itemName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"item"));
                if (!ForgeRegistries.ITEMS.containsKey(itemName)) {
                    SophisticatedBackpacks.LOGGER.debug("{} isn't loaded in item registry, skipping ...", (Object)itemName);
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
                return Optional.of(st -> st.func_77973_b() == item && (st.func_77978_p() == null || st.func_77978_p().isEmpty()));
            }
        });
        BLOCK_MATCHER_FACTORIES.add(new IMatcherFactory<BlockContext>(){

            @Override
            public boolean appliesTo(JsonElement jsonElement) {
                return jsonElement.isJsonPrimitive();
            }

            @Override
            public Optional<Predicate<BlockContext>> getPredicate(JsonElement jsonElement) {
                String modId = jsonElement.getAsString();
                if (!ModList.get().isLoaded(modId)) {
                    SophisticatedBackpacks.LOGGER.debug("{} mod isn't loaded, skipping ...", (Object)modId);
                    return Optional.empty();
                }
                return Optional.of(new ModMatcher<Block, BlockContext>(modId, BlockContext::getBlock));
            }
        });
        BLOCK_MATCHER_FACTORIES.add((IMatcherFactory<BlockContext>)new TypedMatcherFactory<BlockContext>("all"){

            @Override
            protected Optional<Predicate<BlockContext>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(block -> true);
            }
        });
        BLOCK_MATCHER_FACTORIES.add((IMatcherFactory<BlockContext>)new TypedMatcherFactory<BlockContext>("rail"){

            @Override
            protected Optional<Predicate<BlockContext>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(blockContext -> blockContext.getBlock() instanceof AbstractRailBlock);
            }
        });
        BLOCK_MATCHER_FACTORIES.add((IMatcherFactory<BlockContext>)new TypedMatcherFactory<BlockContext>("item_handler"){

            @Override
            protected Optional<Predicate<BlockContext>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(blockContext -> WorldHelper.getTile((IBlockReader)blockContext.getWorld(), blockContext.getPos()).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()).orElse(false));
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("animal"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(entity -> entity instanceof AnimalEntity);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("living"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(entity -> entity instanceof LivingEntity);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("bee"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(entity -> entity instanceof BeeEntity);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("tameable"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(entity -> entity instanceof TameableEntity);
            }
        });
    }
}

