/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.compacting;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class CompactingUpgradeWrapper
extends UpgradeWrapperBase<CompactingUpgradeWrapper, CompactingUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToCompact = new HashSet<Integer>();

    public CompactingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((CompactingUpgradeItem)this.upgradeItem).getFilterSlotCount(), stack -> !stack.func_77942_o() && !RecipeHelper.getItemCompactingShapes(stack.func_77973_b()).isEmpty());
    }

    @Override
    public ItemStack onBeforeInsert(IItemHandlerSimpleInserter inventoryHandler, int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public void onAfterInsert(IItemHandlerSimpleInserter inventoryHandler, int slot) {
        this.compactSlot(inventoryHandler, slot);
    }

    private void compactSlot(IItemHandlerSimpleInserter inventoryHandler, int slot) {
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (slotStack.func_190926_b() || slotStack.func_77942_o() || !this.filterLogic.matchesFilter(slotStack)) {
            return;
        }
        Item item = slotStack.func_77973_b();
        Set<RecipeHelper.CompactingShape> shapes = RecipeHelper.getItemCompactingShapes(item);
        if (((CompactingUpgradeItem)this.upgradeItem).shouldCompactThreeByThree() && (shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE))) {
            this.tryCompacting(inventoryHandler, item, 3, 3);
        } else if (shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            this.tryCompacting(inventoryHandler, item, 2, 2);
        }
    }

    private void tryCompacting(IItemHandlerSimpleInserter inventoryHandler, Item item, int width, int height) {
        int totalCount = width * height;
        RecipeHelper.CompactingResult compactingResult = RecipeHelper.getCompactingResult(item, width, height);
        if (!compactingResult.getResult().func_190926_b()) {
            ItemStack extractedStack = InventoryHelper.extractFromInventory(item, totalCount, (IItemHandler)inventoryHandler, true);
            while (extractedStack.func_190916_E() == totalCount && this.fitsResultAndRemainingItems((IItemHandler)inventoryHandler, compactingResult.getRemainingItems(), compactingResult.getResult())) {
                InventoryHelper.extractFromInventory(item, totalCount, (IItemHandler)inventoryHandler, false);
                inventoryHandler.insertItem(compactingResult.getResult(), false);
                InventoryHelper.insertIntoInventory(compactingResult.getRemainingItems(), (IItemHandler)inventoryHandler, false);
                extractedStack = InventoryHelper.extractFromInventory(item, totalCount, (IItemHandler)inventoryHandler, true);
            }
        }
    }

    private boolean fitsResultAndRemainingItems(IItemHandler inventoryHandler, List<ItemStack> remainingItems, ItemStack result) {
        if (!remainingItems.isEmpty()) {
            IItemHandler clonedHandler = InventoryHelper.cloneInventory(inventoryHandler);
            return InventoryHelper.insertIntoInventory(result, clonedHandler, false).func_190926_b() && InventoryHelper.insertIntoInventory(remainingItems, clonedHandler, false).isEmpty();
        }
        return InventoryHelper.insertIntoInventory(result, inventoryHandler, true).func_190926_b();
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldCompactNonUncraftable() {
        return NBTHelper.getBoolean(this.upgrade, "compactNonUncraftable").orElse(false);
    }

    public void setCompactNonUncraftable(boolean shouldCompactNonUncraftable) {
        NBTHelper.setBoolean(this.upgrade, "compactNonUncraftable", shouldCompactNonUncraftable);
        this.save();
    }

    @Override
    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (this.shouldWorkInGUI()) {
            this.slotsToCompact.add(slot);
        }
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean(this.upgrade, "shouldWorkInGUI", shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean(this.upgrade, "shouldWorkInGUI").orElse(false);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.slotsToCompact.isEmpty()) {
            return;
        }
        for (int slot : this.slotsToCompact) {
            this.compactSlot(this.backpackWrapper.getInventoryHandler(), slot);
        }
        this.slotsToCompact.clear();
    }
}

