/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.BlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.SmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.SmokingUpgradeItem;

public abstract class CookingUpgradeWrapper<W extends CookingUpgradeWrapper<W, U, R>, U extends UpgradeItemBase<W>, R extends AbstractCookingRecipe>
extends UpgradeWrapperBase<W, U>
implements ITickableUpgrade,
ICookingUpgrade<R> {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    protected final CookingLogic<R> cookingLogic;

    protected CookingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler, Config.Common.CookingUpgradeConfig cookingUpgradeConfig, IRecipeType<R> recipeType, float burnTimeModifier) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.cookingLogic = new CookingLogic<R>(upgrade, upgradeSaveHandler, cookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        if (!this.cookingLogic.tick(world)) {
            this.setCooldown(world, 10);
        }
        boolean isBurning = this.cookingLogic.isBurning(world);
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        if (renderInfo.getUpgradeRenderData(CookingUpgradeRenderData.TYPE).map(CookingUpgradeRenderData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeRenderData(CookingUpgradeRenderData.TYPE, new CookingUpgradeRenderData(true));
            } else {
                renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.pauseAndRemoveRenderInfo();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void onBeforeRemoved() {
        this.pauseAndRemoveRenderInfo();
    }

    private void pauseAndRemoveRenderInfo() {
        this.cookingLogic.pause();
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
    }

    @Override
    public CookingLogic<R> getCookingLogic() {
        return this.cookingLogic;
    }

    public static class BlastingUpgradeWrapper
    extends CookingUpgradeWrapper<BlastingUpgradeWrapper, BlastingUpgradeItem, BlastingRecipe> {
        public BlastingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler, Config.COMMON.blastingUpgrade, IRecipeType.field_222151_c, 0.5f);
        }
    }

    public static class SmokingUpgradeWrapper
    extends CookingUpgradeWrapper<SmokingUpgradeWrapper, SmokingUpgradeItem, SmokingRecipe> {
        public SmokingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler, Config.COMMON.smokingUpgrade, IRecipeType.field_222152_d, 0.5f);
        }
    }

    public static class SmeltingUpgradeWrapper
    extends CookingUpgradeWrapper<SmeltingUpgradeWrapper, SmeltingUpgradeItem, FurnaceRecipe> {
        public SmeltingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler, Config.COMMON.smeltingUpgrade, IRecipeType.field_222150_b, 1.0f);
        }
    }
}

