/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FeedingUpgradeItem)this.upgradeItem).getFilterSlotCount(), ItemStack::func_222117_E);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.isInCooldown(world) || entity != null && !(entity instanceof PlayerEntity)) {
            return;
        }
        if (entity == null) {
            world.func_217394_a(EntityType.field_200729_aH, new AxisAlignedBB(pos).func_186662_g(3.0), p -> true).forEach(p -> this.feedPlayerAndGetHungry((PlayerEntity)p, world));
        } else if (this.feedPlayerAndGetHungry((PlayerEntity)entity, world)) {
            this.setCooldown(world, 10);
            return;
        }
        this.setCooldown(world, 100);
    }

    private boolean feedPlayerAndGetHungry(PlayerEntity player, World world) {
        int hungerLevel = 20 - player.func_71024_bL().func_75116_a();
        if (hungerLevel == 0) {
            return false;
        }
        return this.tryFeedingFoodFromBackpack(world, hungerLevel, player) && player.func_71024_bL().func_75116_a() < 20;
    }

    private boolean tryFeedingFoodFromBackpack(World world, int hungerLevel, PlayerEntity player) {
        boolean isHurt = player.func_110143_aJ() < player.func_110138_aP() - 0.1f;
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        AtomicBoolean fedPlayer = new AtomicBoolean(false);
        InventoryHelper.iterate((IItemHandler)inventory, (slot, stack) -> {
            if (stack.func_222117_E() && this.filterLogic.matchesFilter((ItemStack)stack) && (this.isHungryEnoughForFood(hungerLevel, (ItemStack)stack) || this.shouldFeedImmediatelyWhenHurt() && hungerLevel > 0 && isHurt)) {
                ItemStack mainHandItem = player.func_184614_ca();
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, stack);
                if (stack.func_77957_a(world, player, Hand.MAIN_HAND).func_188397_a() == ActionResultType.CONSUME) {
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)mainHandItem);
                    ItemStack containerItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)stack.func_77946_l(), (int)0, (ItemStack)stack.func_77973_b().func_77654_b(stack, world, (LivingEntity)player));
                    inventory.setStackInSlot(slot.intValue(), (ItemStack)stack);
                    if (!ItemStack.func_77989_b((ItemStack)containerItem, (ItemStack)stack)) {
                        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(playerInventory -> InventoryHelper.insertOrDropItem(player, containerItem, new IItemHandler[]{inventory, playerInventory}));
                    }
                    fedPlayer.set(true);
                    return true;
                }
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)mainHandItem);
            }
            return false;
        }, () -> false, ret -> ret);
        return fedPlayer.get();
    }

    private boolean isHungryEnoughForFood(int hungerLevel, ItemStack stack) {
        HungerLevel feedAtHungerLevel = this.getFeedAtHungerLevel();
        if (feedAtHungerLevel == HungerLevel.ANY) {
            return true;
        }
        int nutrition = stack.func_77973_b().func_219967_s().func_221466_a();
        return (feedAtHungerLevel == HungerLevel.HALF ? nutrition / 2 : nutrition) <= hungerLevel;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public HungerLevel getFeedAtHungerLevel() {
        return NBTHelper.getEnumConstant(this.upgrade, "feedAtHungerLevel", HungerLevel::fromName).orElse(HungerLevel.HALF);
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        NBTHelper.setEnumConstant(this.upgrade, "feedAtHungerLevel", hungerLevel);
        this.save();
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return NBTHelper.getBoolean(this.upgrade, "feedImmediatelyWhenHurt").orElse(true);
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        NBTHelper.setBoolean(this.upgrade, "feedImmediatelyWhenHurt", feedImmediatelyWhenHurt);
        this.save();
    }
}

