/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib;

import com.google.common.collect.BiMap;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.annotations.ProvideRecipes;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.TileRenderer;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.IRecipeProvider;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.api.multipart.MultipartBlock;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.command.CommandHammerLib;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.proxy.HLClientProxy;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.hammerlib.util.charging.ItemChargeHelper;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@Mod(value="hammerlib")
public class HammerLib {
    public static final Logger LOG = LogManager.getLogger((String)"HammerLib");
    public static final HLCommonProxy PROXY = (HLCommonProxy)DistExecutor.unsafeRunForDist(() -> HLClientProxy::new, () -> HLCommonProxy::new);

    public HammerLib() {
        CommonMessages.printMessageOnIllegalRedistribution(HammerLib.class, LOG, "HammerLib", "https://www.curseforge.com/minecraft/mc-mods/hammer-lib");
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        LanguageAdapter.registerMod("hammerlib");
        TagsHL.init();
        ItemChargeHelper.setup();
        ScanDataHelper.lookupAnnotatedObjects(ProvideRecipes.class).forEach(data -> {
            IRecipeProvider provider;
            Class c = ReflectionUtil.fetchClass(data.getClassType());
            if (IRecipeProvider.class.isAssignableFrom(c) && (provider = (IRecipeProvider)UnsafeHacks.newInstance(c)) != null) {
                MinecraftForge.EVENT_BUS.addListener(provider::provideRecipes);
            }
        });
        if (Environment.get().getDist() == Dist.CLIENT) {
            ScanDataHelper.lookupAnnotatedObjects(TileRenderer.class).forEach(data -> {
                if (data.getTargetType() == ElementType.FIELD) {
                    data.getOwnerMod().ifPresent(mc -> mc.getEventBus().addListener(PROXY.addTESR(data.getClassType(), data.getMemberName(), data.getProperty("value").map(Type.class::cast).orElse(null))));
                }
            });
        }
        ScanDataHelper.lookupAnnotatedObjects(SimplyRegister.class).forEach(data -> {
            if (data.getTargetType() == ElementType.TYPE) {
                data.getOwnerMod().ifPresent(mc -> {
                    try {
                        Field f = ReflectionUtil.lookupField(RegistryManager.class, "registries");
                        BiMap registries = (BiMap)Cast.cast(f.get(RegistryManager.ACTIVE));
                        registries.values().forEach(registry -> mc.getEventBus().addGenericListener(registry.getRegistrySuperType(), event -> RegistryAdapter.register(event.getRegistry(), data.getOwnerClass(), mc.getModId())));
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(Setup.class).forEach(data -> {
            if (data.getTargetType() == ElementType.METHOD) {
                LOG.info("Injecting setup into " + data.getClassType());
                data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.setup(event, data.getOwnerClass(), data.getMemberName())));
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(ClientSetup.class).forEach(data -> {
            if (data.getTargetType() == ElementType.METHOD) {
                LOG.info("Injecting client-setup into " + data.getClassType());
                data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.clientSetup(event, data.getOwnerClass(), data.getMemberName())));
            }
        });
        NBTSerializationHelper.construct();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent e) {
        PROXY.clientSetup();
    }

    @SubscribeEvent
    public void finish(FMLLoadCompleteEvent e) {
        PROXY.finishLoading();
    }

    @SubscribeEvent
    public void newRegistries(RegistryEvent.NewRegistry e) {
        new RegistryBuilder().setType(MultipartBlock.class).setName(new ResourceLocation("hammerlib", "multiparts")).create();
    }

    public void registerCommands(RegisterCommandsEvent e) {
        CommandHammerLib.register((CommandDispatcher<CommandSource>)e.getDispatcher());
    }
}

