/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.util.java.Cast;

public class NumberSerializer<N extends Number, NBT extends INBT>
implements INBTSerializer<N> {
    final int nbtType;
    final Function<N, NBT> encode;
    final Function<NBT, N> decode;

    public NumberSerializer(int nbtType, Function<N, NBT> encode, Function<NBT, N> decode) {
        this.nbtType = nbtType;
        this.encode = encode;
        this.decode = decode;
    }

    @Override
    public void serialize(CompoundNBT nbt, String key, N value) {
        if (value != null) {
            nbt.func_218657_a(key, (INBT)this.encode.apply(value));
        }
    }

    @Override
    public N deserialize(CompoundNBT nbt, String key) {
        if (nbt.func_150297_b(key, this.nbtType)) {
            return (N)((Number)this.decode.apply(Cast.cast(nbt.func_74781_a(key))));
        }
        return null;
    }
}

