/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.lighting;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.HandleLightOverrideEvent;
import org.zeith.hammerlib.api.lighting.impl.IGlowingEntity;
import org.zeith.hammerlib.api.lighting.impl.IGlowingItem;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class ColoredLightManager {
    private static final List<Function<Float, Stream<ColoredLight>>> lightGenerators = new ArrayList<Function<Float, Stream<ColoredLight>>>();
    public static final BooleanSupplier COLORED_LIGHTING_ENABLED = () -> false;
    public static final BooleanSupplier SHADER_UNIFORM_SETUP = () -> false;
    public static final BooleanSupplier BIND_TERRAIN = () -> false;
    public static final BooleanSupplier BIND_ENTITY = () -> false;
    public static final BooleanSupplier UNBIND_TERRAIN = () -> false;
    public static final BooleanSupplier UNBIND_ENTITY = () -> false;
    public static IntSupplier UNIFORM_LIGHT_COUNT = () -> 0;
    public static int LAST_LIGHTS;

    public static boolean isColoredLightActive() {
        return COLORED_LIGHTING_ENABLED.getAsBoolean();
    }

    @Deprecated
    public static void registerOperator(BooleanSupplier enabled, BooleanSupplier uniforms, BooleanSupplier bindTerrain, BooleanSupplier unbindTerrain) {
        BooleanSupplier prevBS = COLORED_LIGHTING_ENABLED;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "COLORED_LIGHTING_ENABLED", () -> prevBS != null && prevBS.getAsBoolean() || enabled.getAsBoolean());
        BooleanSupplier prevSUS = SHADER_UNIFORM_SETUP;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "SHADER_UNIFORM_SETUP", () -> {
            boolean got = prevSUS.getAsBoolean();
            return uniforms.getAsBoolean() || got;
        });
        BooleanSupplier prevBT = BIND_TERRAIN;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "BIND_TERRAIN", () -> {
            boolean got = prevBT.getAsBoolean();
            return bindTerrain.getAsBoolean() || got;
        });
        BooleanSupplier prevUBT = UNBIND_TERRAIN;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "UNBIND_TERRAIN", () -> {
            boolean got = prevUBT.getAsBoolean();
            return unbindTerrain.getAsBoolean() || got;
        });
    }

    public static void registerOperator(BooleanSupplier enabled, BooleanSupplier uniforms, BooleanSupplier bindTerrain, BooleanSupplier bindEntity, BooleanSupplier unbindTerrain, BooleanSupplier unbindEntity) {
        BooleanSupplier prevBS = COLORED_LIGHTING_ENABLED;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "COLORED_LIGHTING_ENABLED", () -> prevBS != null && prevBS.getAsBoolean() || enabled.getAsBoolean());
        BooleanSupplier prevSUS = SHADER_UNIFORM_SETUP;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "SHADER_UNIFORM_SETUP", () -> {
            boolean got = prevSUS.getAsBoolean();
            return uniforms.getAsBoolean() || got;
        });
        BooleanSupplier prevBT = BIND_TERRAIN;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "BIND_TERRAIN", () -> {
            boolean got = prevBT.getAsBoolean();
            return bindTerrain.getAsBoolean() || got;
        });
        BooleanSupplier prevBE = BIND_ENTITY;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "BIND_ENTITY", () -> {
            boolean got = prevBE.getAsBoolean();
            return bindEntity.getAsBoolean() || got;
        });
        BooleanSupplier prevUBT = UNBIND_TERRAIN;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "UNBIND_TERRAIN", () -> {
            boolean got = prevUBT.getAsBoolean();
            return unbindTerrain.getAsBoolean() || got;
        });
        BooleanSupplier prevUBE = UNBIND_ENTITY;
        ReflectionUtil.setStaticFinalField(ColoredLightManager.class, "UNBIND_ENTITY", () -> {
            boolean got = prevUBE.getAsBoolean();
            return unbindEntity.getAsBoolean() || got;
        });
    }

    public static <A, B, C> Function<A, C> dfunc(Function<A, B> fa, Function<B, C> fb) {
        return a -> fb.apply(fa.apply(a));
    }

    public static PlayerEntity getClientPlayer() {
        return HammerLib.PROXY.getClientPlayer();
    }

    public static void addGenerator(Function<Float, Stream<ColoredLight>> gen) {
        lightGenerators.add(gen);
    }

    public static Stream<ColoredLight> generate(float partialTicks) {
        return lightGenerators.stream().flatMap(f -> (Stream)f.apply(Float.valueOf(partialTicks))).filter(Predicates.notNull());
    }

    static {
        ColoredLightManager.addGenerator(partialTicks -> {
            PlayerEntity pl = ColoredLightManager.getClientPlayer();
            if (pl != null) {
                List ents = pl.field_70170_p.func_217357_a(Entity.class, pl.func_174813_aQ().func_186662_g(128.0));
                Stream players = ents.stream().flatMap(ent -> {
                    ItemEntity ei;
                    ItemStack item;
                    IGlowingItem igi;
                    Stream.Builder<ColoredLight> lights = Stream.builder();
                    if (ent instanceof LivingEntity) {
                        ItemStack off;
                        LivingEntity base = (LivingEntity)ent;
                        ItemStack main = base.func_184614_ca();
                        IGlowingItem igi2 = IGlowingItem.fromStack(main);
                        if (igi2 != null) {
                            lights.add(igi2.produceColoredLight((Entity)base, main));
                        }
                        if ((igi2 = IGlowingItem.fromStack(off = base.func_184592_cb())) != null) {
                            lights.add(igi2.produceColoredLight((Entity)base, off));
                        }
                    } else if (ent instanceof ItemEntity && (igi = IGlowingItem.fromStack(item = (ei = (ItemEntity)ent).func_92059_d())) != null) {
                        lights.add(igi.produceColoredLight((Entity)ei, item));
                    }
                    return lights.build().filter(Predicates.notNull()).map(l -> l.reposition((Entity)ent, partialTicks.floatValue()));
                });
                Stream<ColoredLight> entities = Stream.concat(players, ents.stream().map(e -> {
                    ColoredLight l = e instanceof IGlowingEntity ? ((IGlowingEntity)e).produceColoredLight(partialTicks.floatValue()) : null;
                    HandleLightOverrideEvent<Entity> evt = new HandleLightOverrideEvent<Entity>((Entity)e, partialTicks.floatValue(), l);
                    MinecraftForge.EVENT_BUS.post(evt);
                    return evt.getNewLight();
                }));
                entities = Stream.concat(entities, HammerLib.PROXY.getGlowingParticles(partialTicks.floatValue()));
                Stream<ColoredLight> tiles = pl.field_70170_p.field_147482_g.stream().map(e -> {
                    ColoredLight l = e instanceof IGlowingEntity ? ((IGlowingEntity)e).produceColoredLight(partialTicks.floatValue()) : null;
                    HandleLightOverrideEvent<TileEntity> evt = new HandleLightOverrideEvent<TileEntity>((TileEntity)e, partialTicks.floatValue(), l);
                    MinecraftForge.EVENT_BUS.post(evt);
                    return evt.getNewLight();
                });
                return Stream.concat(tiles, entities);
            }
            return Stream.empty();
        });
    }
}

