/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.pipelines.shaders;

import java.util.Objects;
import org.zeith.hammerlib.client.pipelines.shaders.VariableShaderProgram;

public abstract class ShaderVar {
    public boolean hasChanged;
    final String key;
    String value;
    VariableShaderProgram program;

    public ShaderVar(String key) {
        this.key = key;
    }

    protected abstract String getCurrentValue();

    public void update() {
        String nv = this.getCurrentValue();
        if (!Objects.equals(nv, this.value)) {
            this.value = nv;
            this.hasChanged = true;
        }
    }

    public String getValue() {
        return this.value;
    }

    void setProgram(VariableShaderProgram program) {
        if (this.program != null) {
            throw new IllegalStateException(this + " is already assigned to shader program " + this.program);
        }
        this.program = program;
    }

    public VariableShaderProgram getProgram() {
        return this.program;
    }

    public String toString() {
        return "ShaderVar{key='" + this.key + '\'' + ", program=" + this.program + '}';
    }
}

