/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render.item;

import com.google.common.io.Files;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;

public class ItemTextureRenderer
implements Closeable {
    private ItemRenderer renderer;
    private Framebuffer smallBuffer;
    private Framebuffer largeBuffer;

    public ItemTextureRenderer(ItemRenderer renderer, int imageSize) {
        this.renderer = renderer;
        this.smallBuffer = new Framebuffer(imageSize, imageSize, true, true);
        this.largeBuffer = new Framebuffer(3 * imageSize, 3 * imageSize, true, true);
    }

    public void renderItemstack(ItemStack is, File output, boolean includesBorders) throws IOException {
        Framebuffer fb = includesBorders ? this.largeBuffer : this.smallBuffer;
        fb.func_147610_a(true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clear((int)16384, (boolean)true);
        RenderSystem.clear((int)256, (boolean)true);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        if (includesBorders) {
            RenderSystem.ortho((double)-16.0, (double)32.0, (double)32.0, (double)-16.0, (double)-1000.0, (double)3000.0);
        } else {
            RenderSystem.ortho((double)0.0, (double)16.0, (double)16.0, (double)0.0, (double)-1000.0, (double)3000.0);
        }
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
        this.renderer.func_175042_a(is, 0, 0);
        RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        fb.func_147612_c();
        try (NativeImage ni = new NativeImage(fb.field_147622_a, fb.field_147620_b, true);){
            ni.func_195717_a(fb.func_242996_f(), false);
            ni.func_195710_e();
            Files.createParentDirs((File)output);
            ni.func_209271_a(output);
        }
        fb.func_147609_e();
        fb.func_147606_d();
    }

    @Override
    public void close() {
        this.smallBuffer.func_147608_a();
        this.largeBuffer.func_147608_a();
    }
}

