/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;
import org.zeith.hammerlib.client.utils.GLHelperHL;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.hammerlib.util.java.itf.IntToIntFunction;

public class RenderUtils {
    public static double zLevel = 0.0;
    public static final Function<ResourceLocation, TextureAtlasSprite> spriteGetter = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
    private static final Random rand = new Random();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static TextureAtlasSprite getMainSprite(ResourceLocation tex) {
        return spriteGetter.apply(tex);
    }

    public static void drawFullRectangleFit(double x, double y, double width, double height) {
        int w = GLHelperHL.activeTextureWidth();
        int h = GLHelperHL.activeTextureHeight();
        float ws = 1.0f;
        float hs = 1.0f;
        if (w > h) {
            hs = (float)h / (float)w;
        }
        if (h > w) {
            ws = (float)w / (float)h;
        }
        double nw = width * (double)ws;
        double nh = height * (double)hs;
        RenderUtils.drawFullTexturedModalRect(x + (width - nw) / 2.0, y + (height - nh) / 2.0, nw, nh);
    }

    public static void drawTexturedModalRect(double x, double y, double texX, double texY, double width, double height) {
        float n = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_225582_a_(x, y + height, zLevel).func_225583_a_((float)texX * n, (float)(texY + height) * n).func_181675_d();
        vb.func_225582_a_(x + width, y + height, zLevel).func_225583_a_((float)(texX + width) * n, (float)(texY + height) * n).func_181675_d();
        vb.func_225582_a_(x + width, y, zLevel).func_225583_a_((float)(texX + width) * n, (float)texY * n).func_181675_d();
        vb.func_225582_a_(x, y, zLevel).func_225583_a_((float)texX * n, (float)texY * n).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawFullTexturedModalRect(double x, double y, double width, double height) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_225582_a_(x, y + height, zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        vb.func_225582_a_(x + width, y + height, zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        vb.func_225582_a_(x + width, y, zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        vb.func_225582_a_(x, y, zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawColoredModalRect(double x, double y, double width, double height, int rgb) {
        float r = ColorHelper.getRed(rgb);
        float g = ColorHelper.getGreen(rgb);
        float b = ColorHelper.getBlue(rgb);
        float a = ColorHelper.getAlpha(rgb);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vb.func_225582_a_(x, y + height, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        vb.func_225582_a_(x + width, y + height, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        vb.func_225582_a_(x + width, y, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        vb.func_225582_a_(x, y, zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawTexturedModalRect(double x, double y, double texX, double texY, double width, double height, double zLevel) {
        float n = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_225582_a_(x, y + height, zLevel).func_225583_a_((float)texX * n, (float)(texY + height) * n).func_181675_d();
        vb.func_225582_a_(x + width, y + height, zLevel).func_225583_a_((float)(texX + width) * n, (float)(texY + height) * n).func_181675_d();
        vb.func_225582_a_(x + width, y, zLevel).func_225583_a_((float)(texX + width) * n, (float)texY * n).func_181675_d();
        vb.func_225582_a_(x, y, zLevel).func_225583_a_((float)texX * n, (float)texY * n).func_181675_d();
        tess.func_78381_a();
    }

    public static void drawTexturedModalRect(double xCoord, double yCoord, @Nullable TextureAtlasSprite textureSprite, double widthIn, double heightIn) {
        float minU = textureSprite == null ? 0.0f : textureSprite.func_94209_e();
        float minV = textureSprite == null ? 0.0f : textureSprite.func_94206_g();
        float maxU = textureSprite == null ? 1.0f : textureSprite.func_94212_f();
        float maxV = textureSprite == null ? 1.0f : textureSprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_225582_a_(xCoord, yCoord + heightIn, 0.0).func_225583_a_(minU, maxV).func_181675_d();
        vertexbuffer.func_225582_a_(xCoord + widthIn, yCoord + heightIn, 0.0).func_225583_a_(maxU, maxV).func_181675_d();
        vertexbuffer.func_225582_a_(xCoord + widthIn, yCoord, 0.0).func_225583_a_(maxU, minV).func_181675_d();
        vertexbuffer.func_225582_a_(xCoord, yCoord, 0.0).func_225583_a_(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRect(double left, double top, double width, double height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_225582_a_(left + width, top, zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_225582_a_(left, top, zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_225582_a_(left, top + height, zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_225582_a_(left + width, top + height, zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawGradientRect(double left, double top, double width, double height, int startColor, int endColor, double zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_225582_a_(left + width, top, zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_225582_a_(left, top, zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_225582_a_(left, top + height, zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_225582_a_(left + width, top + height, zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawTextRGBA(FontRenderer font, MatrixStack stack, String s, int x, int y, int r, int g, int b, int a) {
        font.func_238421_b_(stack, s, (float)x, (float)y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void drawTextRGBA(FontRenderer font, MatrixStack stack, ITextComponent s, int x, int y, int r, int g, int b, int a) {
        font.func_243248_b(stack, s, (float)x, (float)y, ColorHelper.packARGB(r, g, b, a));
    }

    public static void drawLine(Vector3d start, Vector3d end, int color, float size) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        ColorHelper.glColor1ia(color);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
        GL11.glVertex3d((double)end.field_72450_a, (double)end.field_72448_b, (double)end.field_72449_c);
        GL11.glEnd();
        GL11.glPopMatrix();
        RenderSystem.enableTexture();
        ColorHelper.glColor1ia(-1);
    }

    public static void drawBrokenLine(int color, float size, Vector3d ... points) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        ColorHelper.glColor1ia(color);
        GL11.glPushMatrix();
        GL11.glLineWidth((float)size);
        GL11.glBegin((int)1);
        for (Vector3d point : points) {
            GL11.glVertex3d((double)point.field_72450_a, (double)point.field_72448_b, (double)point.field_72449_c);
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        RenderSystem.enableTexture();
        ColorHelper.glColor1ia(-1);
    }

    public static void renderColorfulLightRayEffects(IRenderTypeBuffer buffers, MatrixStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderColorfulLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void renderLightRayEffects(IRenderTypeBuffer buffers, MatrixStack matrix, int rgba, long seed, float progress, int dstJump, int rayCount) {
        RenderUtils.renderLightRayEffects(buffers, matrix, rgba, seed, progress, dstJump, 1.0f, rayCount);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        RenderSystem.clearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static void renderLightRayEffects(IRenderTypeBuffer buffers, MatrixStack matrix, int rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        int r = rgba >> 16 & 0xFF;
        int g = rgba >> 8 & 0xFF;
        int b = rgba & 0xFF;
        int a = rgba >> 24 & 0xFF;
        IVertexBuilder ivertexbuilder2 = buffers.getBuffer(RenderType.func_228657_l_());
        matrix.func_227860_a_();
        for (int i = 0; i < rayCount; ++i) {
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
            RenderUtils.vertex01(ivertexbuilder2, mat, r, g, b, a);
            RenderUtils.vertex2(ivertexbuilder2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(ivertexbuilder2, mat, r, g, b, a);
            RenderUtils.vertex3(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(ivertexbuilder2, mat, r, g, b, a);
            RenderUtils.vertex4(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(ivertexbuilder2, mat, f3, f4, r, g, b);
        }
        matrix.func_227865_b_();
    }

    public static void renderColorfulLightRayEffects(IRenderTypeBuffer buffers, MatrixStack matrix, IntToIntFunction rgba, long seed, float progress, int dstJump, float scale, int rayCount) {
        rand.setSeed(seed);
        float dstJumpScale = 30.0f / (Math.min((float)dstJump, 10.0f * scale) / 10.0f);
        float f7 = Math.min(progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f, 1.0f);
        IVertexBuilder ivertexbuilder2 = buffers.getBuffer(RenderType.func_228657_l_());
        matrix.func_227860_a_();
        for (int i = 0; i < rayCount; ++i) {
            int irgba = rgba.applyAsInt(i);
            int r = irgba >> 16 & 0xFF;
            int g = irgba >> 8 & 0xFF;
            int b = irgba & 0xFF;
            int a = irgba >> 24 & 0xFF;
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rand.nextFloat() * 360.0f));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rand.nextFloat() * 360.0f + progress * 360.0f));
            float f3 = rand.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = rand.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
            RenderUtils.vertex01(ivertexbuilder2, mat, r, g, b, a);
            RenderUtils.vertex2(ivertexbuilder2, mat, f3 /= dstJumpScale, f4 /= dstJumpScale, r, g, b);
            RenderUtils.vertex3(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(ivertexbuilder2, mat, r, g, b, a);
            RenderUtils.vertex3(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex4(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex01(ivertexbuilder2, mat, r, g, b, a);
            RenderUtils.vertex4(ivertexbuilder2, mat, f3, f4, r, g, b);
            RenderUtils.vertex2(ivertexbuilder2, mat, f3, f4, r, g, b);
        }
        matrix.func_227865_b_();
    }

    private static void vertex01(IVertexBuilder p_229061_0_, Matrix4f p_229061_1_, int r, int g, int b, int a) {
        p_229061_0_.func_227888_a_(p_229061_1_, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        p_229061_0_.func_227888_a_(p_229061_1_, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
    }

    private static void vertex2(IVertexBuilder p_229060_0_, Matrix4f p_229060_1_, float p_229060_2_, float p_229060_3_, int r, int g, int b) {
        p_229060_0_.func_227888_a_(p_229060_1_, -HALF_SQRT_3 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).func_225586_a_(r, g, b, 0).func_181675_d();
    }

    private static void vertex3(IVertexBuilder p_229062_0_, Matrix4f p_229062_1_, float p_229062_2_, float p_229062_3_, int r, int g, int b) {
        p_229062_0_.func_227888_a_(p_229062_1_, HALF_SQRT_3 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).func_225586_a_(r, g, b, 0).func_181675_d();
    }

    private static void vertex4(IVertexBuilder p_229063_0_, Matrix4f p_229063_1_, float p_229063_2_, float p_229063_3_, int r, int g, int b) {
        p_229063_0_.func_227888_a_(p_229063_1_, 0.0f, p_229063_2_, p_229063_3_).func_225586_a_(r, g, b, 0).func_181675_d();
    }

    public static void drawHorizontalGradientRect(float left, float top, float width, float height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float right = left + width;
        float bottom = top + height;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawVerticalGradientRect(float left, float top, float width, float height, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float right = left + width;
        float bottom = top + height;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderSystem.disableTexture();
        RenderUtils.drawColoredModalRect(x, y, width, height, color);
        RenderSystem.enableTexture();
    }

    public static class PlayerRenderUtil {
        public static void rotateIfSneaking(PlayerEntity player) {
            if (player.func_225608_bj_()) {
                PlayerRenderUtil.applySneakingRotation();
            }
        }

        public static void applySneakingRotation() {
            GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            GL11.glRotatef((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
        }

        public static void translateToHeadLevel(PlayerEntity player) {
            GL11.glTranslatef((float)0.0f, (float)(-player.func_70047_e()), (float)0.0f);
            if (player.func_225608_bj_()) {
                GL11.glTranslatef((float)(0.25f * MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f))), (float)(0.25f * MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f))), (float)0.0f);
            }
        }

        public static void translateToFace() {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-4.35f, (float)-1.27f);
        }

        public static void defaultTransforms() {
            GL11.glTranslatef((float)0.0f, (float)3.0f, (float)1.0f);
            GL11.glScalef((float)0.55f, (float)0.55f, (float)0.55f);
        }

        public static void translateToChest() {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-3.2f, (float)-0.85f);
        }
    }
}

