/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.zeith.hammerlib.util.java.io.win32.ZoneIdentifier;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class ModSourceAdapter {
    public static final List<IllegalSite> ILLEGAL_SITES;

    public static Optional<ModSource> getModSource(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(ModFileInfo::getFile).map(ModFile::getFilePath).map(Path::toFile).flatMap(ZoneIdentifier::forFileSafe).map(ModSource::new);
    }

    public static Optional<ModSource> getModSource(Class<?> modClass) {
        try {
            File modFile = null;
            Mod mod = modClass.getDeclaredAnnotation(Mod.class);
            if (mod != null) {
                modFile = ModList.get().getModFileById(mod.value()).getFile().getFilePath().toFile();
            }
            if (modFile == null) {
                modFile = ModSourceAdapter.pathOf(modClass.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile();
            }
            return ZoneIdentifier.forFile(modFile).map(ModSource::new);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return Optional.empty();
        }
    }

    public static Path pathOf(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Missing scheme");
        }
        if (scheme.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider().getPath(uri);
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
            return provider.getPath(uri);
        }
        throw new FileSystemNotFoundException("Provider \"" + scheme + "\" not installed");
    }

    static {
        List illegalSites = Collections.emptyList();
        try {
            illegalSites = Stream.of(new JSONTokener(HttpRequest.get("https://api.stopmodreposts.org/minecraft/sites.json").userAgent("HammerLib").body()).nextValueARR().orElse(null)).filter(Objects::nonNull).flatMap(array -> IntStream.range(0, array.length()).mapToObj(array::getJSONObject).map(IllegalSite::new)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ILLEGAL_SITES = illegalSites;
    }

    public static final class IllegalSite
    implements Predicate<URL> {
        private final String domain;
        private final String notes;
        private final String path;
        private final String reason;

        public IllegalSite(String domain, String notes, String path, String reason) {
            this.domain = domain;
            this.notes = notes;
            this.path = path;
            this.reason = reason;
        }

        public IllegalSite(JSONObject object) {
            this(object.getString("domain"), object.optString("notes"), object.optString("path"), object.optString("reason"));
        }

        @Override
        public boolean test(URL url) {
            return (url.getHost().equalsIgnoreCase(this.domain) || url.getHost().endsWith("." + this.domain)) && url.getPath().startsWith(this.path);
        }

        public String domain() {
            return this.domain;
        }

        public String notes() {
            return this.notes;
        }

        public String path() {
            return this.path;
        }

        public String reason() {
            return this.reason;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IllegalSite that = (IllegalSite)obj;
            return Objects.equals(this.domain, that.domain) && Objects.equals(this.notes, that.notes) && Objects.equals(this.path, that.path) && Objects.equals(this.reason, that.reason);
        }

        public int hashCode() {
            return Objects.hash(this.domain, this.notes, this.path, this.reason);
        }

        public String toString() {
            return "IllegalSite[domain=" + this.domain + ", notes=" + this.notes + ", path=" + this.path + ", reason=" + this.reason + ']';
        }
    }

    public static final class ModSource {
        private final String referrerUrl;
        private final String hostUrl;

        public ModSource(String referrerUrl, String hostUrl) {
            this.referrerUrl = referrerUrl;
            this.hostUrl = hostUrl;
        }

        public ModSource(ZoneIdentifier id) {
            this(id.referrerUrl, id.hostUrl);
        }

        public boolean wasDownloadedIllegally() {
            try {
                List<URL> urls = Arrays.asList(new URL(this.referrerUrl), new URL(this.hostUrl));
                return ILLEGAL_SITES.stream().anyMatch(site -> urls.stream().anyMatch(site));
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public String referrerDomain() {
            try {
                return new URL(this.referrerUrl).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                return this.referrerUrl;
            }
        }

        public String referrerUrl() {
            return this.referrerUrl;
        }

        public String hostUrl() {
            return this.hostUrl;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ModSource that = (ModSource)obj;
            return Objects.equals(this.referrerUrl, that.referrerUrl) && Objects.equals(this.hostUrl, that.hostUrl);
        }

        public int hashCode() {
            return Objects.hash(this.referrerUrl, this.hostUrl);
        }

        public String toString() {
            return "ModSource[referrerUrl=" + this.referrerUrl + ", hostUrl=" + this.hostUrl + ']';
        }
    }
}

